/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.scripts;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import org.gcube.common.core.utils.logging.GCUBELog;

public class OSCommandGenericWorker {
    Boolean aborted = false;
    Boolean success = false;
    String errorReported = "";

    public String ExecuteGetLine(String cmd, final GCUBELog logger) throws Exception {
        Process process = null;
        String lastline = "";
        class ErrorController
        implements Runnable {
            BufferedReader reader;

            public ErrorController(BufferedReader reader) {
                this.reader = reader;
            }

            @Override
            public void run() {
                try {
                    String errorLine = this.reader.readLine();
                    while (!OSCommandGenericWorker.this.aborted.booleanValue() && !OSCommandGenericWorker.this.success.booleanValue()) {
                        if (errorLine != null && errorLine.length() > 0 && !errorLine.contains("WARN") && !errorLine.contains("warn")) {
                            OSCommandGenericWorker.this.aborted = true;
                            logger.debug((Object)("GenericWorker-> OSCommand-> error line->" + errorLine));
                            OSCommandGenericWorker.this.errorReported = errorLine;
                            break;
                        }
                        Thread.sleep(3000L);
                    }
                    logger.debug((Object)"GenericWorker-> OSCommand-> Closing Error Watcher");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ErrorController econtrol = null;
        try {
            logger.debug((Object)("GenericWorker-> OSCommand-> Executing Control ->" + cmd));
            process = Runtime.getRuntime().exec(cmd);
            BufferedReader berror = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            econtrol = new ErrorController(berror);
            Thread t = new Thread(econtrol);
            t.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            logger.debug((Object)("GenericWorker-> OSCommand->  line->" + line));
            while (line != null && !this.aborted.booleanValue()) {
                try {
                    lastline = line;
                    logger.debug((Object)("GenericWorker-> OSCommand-> line->" + line));
                    line = br.readLine();
                }
                catch (EOFException e) {
                    logger.debug((Object)"GenericWorker-> OSCommand -> Process Finished with EOF");
                    break;
                }
                catch (Exception e) {
                    this.success = false;
                    line = "ERROR";
                    break;
                }
            }
            if (this.aborted.booleanValue()) {
                logger.debug((Object)"GenericWorker-> OSCommand -> Process was aborted due to an Error");
                throw new Exception("Internal Error in script execution: " + this.errorReported);
            }
            if (line == null) {
                this.success = true;
                logger.debug((Object)("GenericWorker-> OSCommand -> Success " + this.success));
            }
            logger.debug((Object)"GenericWorker-> OSCommand -> Process Finished");
        }
        catch (Exception e) {
            logger.debug((Object)("GenericWorker-> OSCommand-> Error " + e.getMessage()));
            logger.debug((Object)("GenericWorker-> OSCommand-> Error from Controller " + this.errorReported));
            lastline = "ERROR";
            this.aborted = true;
            throw e;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            logger.debug((Object)"GenericWorker-> OSCommand-> Process destroyed ");
        }
        return lastline;
    }

    public static boolean FileCopy(String origin, String destination) {
        try {
            int c;
            File inputFile = new File(origin);
            System.out.println("GenericWorker-> OSCommand-> FileCopy-> " + inputFile.length() + " to " + inputFile.canRead());
            for (int counterrors = 0; inputFile.length() == 0L && counterrors < 10; ++counterrors) {
                Thread.sleep(20L);
            }
            File outputFile = new File(destination);
            FileReader in = new FileReader(inputFile);
            FileWriter out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

