/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.Engine;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.CategoryScores;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.DBObjectTranslator;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.Entry;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.SingleResult;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks.Chunk;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks.ReferenceChunk;
import org.gcube.dataanalysis.lexicalmatcher.utils.DistanceCalculator;
import org.gcube.dataanalysis.lexicalmatcher.utils.LexicalLogger;
import org.hibernate.SessionFactory;

public class TimeSeriesChunk
extends Chunk {
    private ArrayList<String> columnEntries;
    private String columnType;
    private LexicalEngineConfiguration config;
    private boolean mustInterrupt;
    private ArrayList<SingleResult> detailedResults;
    private String singletonElement;
    private boolean isSingleton;

    public String getColumnType() {
        return this.columnType;
    }

    public String getSingletonEntry() {
        return this.singletonElement;
    }

    public ArrayList<SingleResult> getDetailedResults() {
        return this.detailedResults;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public TimeSeriesChunk(String timeSeriesName, String timeSeriesColumn, String ColumnType, BigInteger start, int ChunkSize, LexicalEngineConfiguration Config, Engine engine) throws Exception {
        super(engine);
        DBObjectTranslator dbo = new DBObjectTranslator();
        SessionFactory sess = engine.getDBSession();
        this.columnEntries = dbo.retrieveTimeSeriesEntries(sess, timeSeriesName, timeSeriesColumn, start, ChunkSize);
        if (ColumnType == null) {
            this.columnType = DataTypeRecognizer.guessType(this.columnEntries);
            LexicalLogger.getLogger().trace("TimeSeriesChunk-> GUESSED TYPE " + this.columnType + " FOR COLUMN " + timeSeriesColumn);
        }
        this.mustInterrupt = false;
        this.config = Config;
        this.isSingleton = false;
    }

    public TimeSeriesChunk(String singletonString, String ColumnType, BigInteger start, int ChunkSize, LexicalEngineConfiguration Config, Engine engine) throws Exception {
        super(engine);
        this.columnEntries = new ArrayList();
        this.columnEntries.add(singletonString);
        if (ColumnType == null) {
            this.columnType = DataTypeRecognizer.guessType(this.columnEntries);
            LexicalLogger.getLogger().trace("TimeSeriesChunk-> GUESSED TYPE " + this.columnType + " FOR SINGLETON " + singletonString);
        }
        this.mustInterrupt = false;
        this.config = Config;
        this.isSingleton = true;
        this.singletonElement = singletonString;
        this.detailedResults = new ArrayList();
    }

    public boolean mustInterruptProcess() {
        return this.mustInterrupt;
    }

    public void compareToReferenceChunk(HashMap<String, CategoryScores> scoresTable, ReferenceChunk catChunk) throws Exception {
        this.compareToReferenceChunk(scoresTable, catChunk, null);
    }

    public void compareToReferenceChunk(HashMap<String, CategoryScores> scoresTable, ReferenceChunk catChunk, String ColumnFilter) throws Exception {
        CategoryScores categoryScores = scoresTable.get(catChunk.getCategoryName());
        ArrayList<Entry> categoryEntries = catChunk.getReferenceEntries();
        block0: for (String timeSeriesElement : this.columnEntries) {
            for (Entry referenceEntry : categoryEntries) {
                HashMap<String, String> attributes = referenceEntry.getAttributes();
                HashMap<String, String> types = referenceEntry.getTypes();
                boolean anotherReference = true;
                for (String referenceColumn : attributes.keySet()) {
                    if (!types.get(referenceColumn).equals(this.columnType) || ColumnFilter != null && !ColumnFilter.equalsIgnoreCase(referenceColumn)) continue;
                    String attribute = attributes.get(referenceColumn);
                    DistanceCalculator d = new DistanceCalculator();
                    double percentage = d.CD(this.config.useSimpleDistance, timeSeriesElement, attribute, this.isSingleton, this.isSingleton) * 100.0;
                    if (!(percentage > (double)this.config.entryAcceptanceThreshold)) continue;
                    LexicalLogger.getLogger().trace("TimeSeriesChunk->compareToCategoryChunk-> \t\tPercentage between " + timeSeriesElement + " vs. " + attribute + " is: " + percentage + " in " + catChunk.getCategoryName() + ":" + referenceColumn);
                    categoryScores.incrementScore(referenceColumn, (float)percentage, anotherReference);
                    if (this.isSingleton) {
                        SingleResult sr;
                        Double scoredetail;
                        int index = 0;
                        Iterator<SingleResult> i$ = this.detailedResults.iterator();
                        while (i$.hasNext() && !((scoredetail = Double.valueOf((sr = i$.next()).getScore())) < percentage)) {
                            ++index;
                        }
                        this.detailedResults.add(index, new SingleResult(attribute, null, percentage, null, "0"));
                    } else {
                        LexicalLogger.getLogger().trace("TimeSeriesChunk->compareToCategoryChunk-> " + categoryScores.showScores());
                    }
                    if (percentage != 100.0 || !this.isSingleton) continue;
                    this.detailedResults = new ArrayList();
                    this.detailedResults.add(new SingleResult(attribute, null, percentage, null, "0"));
                    this.mustInterrupt = true;
                    break;
                }
                if (!this.mustInterrupt) continue;
                continue block0;
            }
        }
    }
}

