/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.lexicalmatcher.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.dataanalysis.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.lexicalmatcher.utils.LexicalLogger;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class DatabaseFactory {
    public static SessionFactory initDBConnection(String configurationFile) throws Exception {
        String xml = FileTools.readXMLDoc(configurationFile);
        SessionFactory DBSessionFactory = null;
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes())));
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public static SessionFactory initDBConnection(String configurationFile, LexicalEngineConfiguration config) throws Exception {
        InputStream stream;
        if (config == null) {
            return DatabaseFactory.initDBConnection(configurationFile);
        }
        try {
            File fl = new File(configurationFile);
            stream = new FileInputStream(fl);
        }
        catch (Exception e) {
            stream = ClassLoader.getSystemResourceAsStream(configurationFile);
        }
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read(stream);
        List nodes = document.selectNodes("//hibernate-configuration/session-factory/property");
        for (Node currentnode : nodes) {
            String element = currentnode.valueOf("@name");
            if (element.equals("connection.driver_class") && config.getDatabaseDriver() != null) {
                currentnode.setText(config.getDatabaseDriver());
            }
            if (element.equals("connection.url") && config.getDatabaseURL() != null) {
                currentnode.setText(config.getDatabaseURL());
            }
            if (element.equals("connection.username") && config.getDatabaseUserName() != null) {
                currentnode.setText(config.getDatabaseUserName());
            }
            if (element.equals("connection.password") && config.getDatabasePassword() != null) {
                currentnode.setText(config.getDatabasePassword());
            }
            if (element.equals("dialect")) {
                LexicalLogger.getLogger().trace("Dialect -> " + config.getDatabaseDialect());
                if (config.getDatabaseDialect() != null) {
                    currentnode.setText(config.getDatabaseDialect());
                }
            }
            if (element.equals("c3p0.idleConnectionTestPeriod") && config.getDatabaseIdleConnectionTestPeriod() != null) {
                currentnode.setText(config.getDatabaseIdleConnectionTestPeriod());
            }
            if (!element.equals("c3p0.automaticTestTable") || config.getDatabaseAutomaticTestTable() == null) continue;
            currentnode.setText(config.getDatabaseAutomaticTestTable());
        }
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(document.asXML().getBytes())));
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        SessionFactory DBSessionFactory = null;
        DBSessionFactory = cfg.buildSessionFactory();
        stream.close();
        return DBSessionFactory;
    }

    public static List<Object> executeHQLQuery(String query, SessionFactory DBSessionFactory, boolean useSQL) {
        List obj = null;
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            ss.beginTransaction();
            Object qr = null;
            qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
            List result = qr.list();
            ss.getTransaction().commit();
            if (result != null && result.size() != 0) {
                obj = result;
            }
        }
        catch (Exception e) {
            System.out.println(String.format("Error while executing query: %1$s %2$s", query, e.getMessage()));
            DatabaseFactory.rollback((org.hibernate.Session)ss);
        }
        return obj;
    }

    public static void executeHQLUpdate(String query, SessionFactory DBSessionFactory, boolean useSQL) throws Exception {
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            ss.beginTransaction();
            Object qr = null;
            qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
            qr.executeUpdate();
            ss.getTransaction().commit();
        }
        catch (Exception e) {
            DatabaseFactory.rollback((org.hibernate.Session)ss);
            LexicalLogger.getLogger().debug("ERROR IN UPDATE: " + e.getMessage());
            throw e;
        }
    }

    public static void executeSQLUpdate(String query, SessionFactory DBSessionFactory) throws Exception {
        DatabaseFactory.executeHQLUpdate(query, DBSessionFactory, true);
    }

    public static List<Object> executeSQLQuery(String query, SessionFactory DBSessionFactory) {
        return DatabaseFactory.executeHQLQuery(query, DBSessionFactory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback(org.hibernate.Session ss) {
        try {
            if (ss != null && ss.getTransaction() != null) {
                ss.getTransaction().rollback();
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                ss.close();
            }
            catch (Exception ee) {}
        }
    }

    public static void saveObject(Object obj, SessionFactory DBSessionFactory) throws Exception {
        if (DBSessionFactory != null) {
            Session ss = null;
            try {
                ss = DBSessionFactory.getCurrentSession();
                ss.beginTransaction();
                ss.saveOrUpdate(obj);
                ss.getTransaction().commit();
            }
            catch (Exception e) {
                DatabaseFactory.rollback((org.hibernate.Session)ss);
                throw e;
            }
        }
    }
}

