/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.Engine;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks.ChunkSet;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks.ReferenceChunk;
import org.gcube.dataanalysis.lexicalmatcher.utils.MathFunctions;

public class ReferenceChunkSet
extends ChunkSet {
    public ReferenceChunkSet(int MaxNumberOfChunks, int ChunkSize, String CategoryName, String CategoryColumn, LexicalEngineConfiguration config, Engine engine) throws Exception {
        super(MaxNumberOfChunks, ChunkSize, CategoryName, CategoryColumn, config, engine);
    }

    public ReferenceChunkSet(int MaxNumberOfChunks, int ChunkSize, String CategoryName, String CategoryTable, BigInteger numberOfCategoryElements, LexicalEngineConfiguration config, Engine engine) throws Exception {
        super(MaxNumberOfChunks, ChunkSize, CategoryName, CategoryTable, numberOfCategoryElements, config, engine);
    }

    @Override
    protected BigDecimal calculateNumberOfElements() throws Exception {
        BigDecimal numberOfElements = new BigDecimal(this.numberOfEntries);
        return numberOfElements;
    }

    @Override
    public ReferenceChunk nextChunk() {
        ReferenceChunk rc = null;
        while (!this.chunkSet.contains(this.chunkIndex) && this.chunkIndex < this.chunkSetSize) {
            ++this.chunkIndex;
        }
        if (this.chunkIndex < this.chunkSetSize) {
            BigInteger startIndex = MathFunctions.chunk2Index(this.chunkIndex, this.chunkSize);
            try {
                rc = new ReferenceChunk(this.seriesName, this.seriesColumn, startIndex, this.chunkSize, this.engine);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++this.chunkIndex;
        return rc;
    }
}

