/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.util.Misc;
import ucar.nc2.util.URLnaming;
import ucar.nc2.util.xml.Parse;

public class NcMLWriter {
    private static final Namespace ncNS = Catalog.ncmlNS;
    private static Logger log = LoggerFactory.getLogger(NcMLWriter.class);
    private NetcdfDataset ncd;
    private XMLOutputter fmt;
    private Variable aggCoord;

    public String writeXML(NetcdfFile ncfile) throws IOException {
        this.ncd = ncfile instanceof NetcdfDataset ? (NetcdfDataset)ncfile : new NetcdfDataset(ncfile, false);
        this.fmt = new XMLOutputter(Format.getPrettyFormat());
        return this.fmt.outputString(this.makeDocument(null));
    }

    public String writeXML(Variable v) throws IOException {
        this.fmt = new XMLOutputter(Format.getPrettyFormat());
        return this.fmt.outputString(this.makeDocument(null));
    }

    public void writeXML(NetcdfFile ncfile, String filenameOut) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filenameOut, false));
        this.writeXML(ncfile, out, null);
        ((OutputStream)out).close();
    }

    public void writeXML(NetcdfFile ncfile, OutputStream os, String location) throws IOException {
        this.ncd = ncfile instanceof NetcdfDataset ? (NetcdfDataset)ncfile : new NetcdfDataset(ncfile, false);
        this.fmt = new XMLOutputter(Format.getPrettyFormat());
        this.fmt.output(this.makeDocument(location), os);
    }

    public void writeXMLexplicit(NetcdfFile ncfile, OutputStream os, String location) throws IOException {
        this.ncd = ncfile instanceof NetcdfDataset ? (NetcdfDataset)ncfile : new NetcdfDataset(ncfile, false);
        this.fmt = new XMLOutputter(Format.getPrettyFormat());
        Document doc = this.makeDocument(location);
        Element root = doc.getRootElement();
        root.addContent(new Element("explicit", ncNS));
        this.fmt.output(doc, os);
    }

    private Document makeDocument(String location) throws IOException {
        Aggregation agg;
        Element rootElem = new Element("netcdf", ncNS);
        Document doc = new Document(rootElem);
        rootElem.addNamespaceDeclaration(ncNS);
        if (null == location) {
            location = this.ncd.getLocation();
        }
        if (null != location) {
            rootElem.setAttribute("location", URLnaming.canonicalizeWrite(location));
        }
        if (null != this.ncd.getId()) {
            rootElem.setAttribute("id", this.ncd.getId());
        }
        if (null != this.ncd.getTitle()) {
            rootElem.setAttribute("title", this.ncd.getTitle());
        }
        if ((agg = this.ncd.getAggregation()) != null) {
            String aggDimensionName = agg.getDimensionName();
            this.aggCoord = this.ncd.findVariable(aggDimensionName);
        }
        Group rootGroup = this.ncd.getRootGroup();
        this.writeGroup(rootElem, rootGroup);
        return doc;
    }

    public static Element writeAttribute(Attribute att, String elementName, Namespace ns) {
        Element attElem = new Element(elementName, ns);
        attElem.setAttribute("name", att.getShortName());
        DataType dt = att.getDataType();
        if (dt != null && dt != DataType.STRING) {
            attElem.setAttribute("type", dt.toString());
        }
        if (att.getLength() == 0) {
            if (att.isUnsigned()) {
                attElem.setAttribute("isUnsigned", "true");
            }
            return attElem;
        }
        if (att.isString()) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < att.getLength(); ++i) {
                String sval = att.getStringValue(i);
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(sval);
            }
            attElem.setAttribute("value", Parse.cleanCharacterData(buff.toString()));
            if (att.getLength() > 1) {
                attElem.setAttribute("separator", ",");
            }
        } else {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < att.getLength(); ++i) {
                Number val = att.getNumericValue(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(val.toString());
            }
            attElem.setAttribute("value", buff.toString());
            if (att.isUnsigned()) {
                attElem.setAttribute("isUnsigned", "true");
            }
        }
        return attElem;
    }

    public static Element writeDimension(Dimension dim, Namespace ns) {
        Element dimElem = new Element("dimension", ns);
        dimElem.setAttribute("name", dim.getShortName());
        if (dim.isVariableLength()) {
            dimElem.setAttribute("length", "*");
        } else {
            dimElem.setAttribute("length", Integer.toString(dim.getLength()));
        }
        if (dim.isUnlimited()) {
            dimElem.setAttribute("isUnlimited", "true");
        }
        if (dim.isVariableLength()) {
            dimElem.setAttribute("isVariableLength", "true");
        }
        return dimElem;
    }

    public static Element writeEnumTypedef(EnumTypedef etd, Namespace ns) {
        Element typeElem = new Element("enumTypedef", ns);
        typeElem.setAttribute("name", etd.getShortName());
        typeElem.setAttribute("type", etd.getBaseType().toString());
        Map<Integer, String> map = etd.getMap();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            typeElem.addContent(new Element("enum", ns).setAttribute("key", Integer.toString(entry.getKey())).addContent(entry.getValue()));
        }
        return typeElem;
    }

    private Element writeGroup(Element elem, Group group) {
        for (EnumTypedef etd : group.getEnumTypedefs()) {
            elem.addContent(NcMLWriter.writeEnumTypedef(etd, ncNS));
        }
        for (Dimension dim : group.getDimensions()) {
            elem.addContent(NcMLWriter.writeDimension(dim, ncNS));
        }
        for (Attribute att : group.getAttributes()) {
            elem.addContent(NcMLWriter.writeAttribute(att, "attribute", ncNS));
        }
        for (Variable var : group.getVariables()) {
            try {
                elem.addContent(this.writeVariable((VariableEnhanced)((Object)var)));
            }
            catch (ClassCastException e) {
                log.error("var not instanceof VariableEnhanced = " + var.getFullName(), (Throwable)e);
            }
        }
        for (Group g : group.getGroups()) {
            Element groupElem = new Element("group", ncNS);
            groupElem.setAttribute("name", g.getShortName());
            elem.addContent(this.writeGroup(groupElem, g));
        }
        return elem;
    }

    private Element writeVariable(VariableEnhanced var) {
        boolean isStructure = var instanceof Structure;
        Element varElem = new Element("variable", ncNS);
        varElem.setAttribute("name", var.getShortName());
        StringBuilder buff = new StringBuilder();
        List<Dimension> dims = var.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (i > 0) {
                buff.append(" ");
            }
            if (dim.isShared()) {
                buff.append(dim.getShortName());
                continue;
            }
            if (dim.isVariableLength()) {
                buff.append("*");
                continue;
            }
            buff.append(dim.getLength());
        }
        varElem.setAttribute("shape", buff.toString());
        DataType dt = var.getDataType();
        if (dt != null) {
            varElem.setAttribute("type", dt.toString());
            if (dt.isEnum()) {
                varElem.setAttribute("typedef", var.getEnumTypedef().getShortName());
            }
        }
        for (Attribute att : var.getAttributes()) {
            varElem.addContent(NcMLWriter.writeAttribute(att, "attribute", ncNS));
        }
        if (var.isMetadata() || var == this.aggCoord) {
            varElem.addContent(NcMLWriter.writeValues(var, ncNS, true));
        }
        if (isStructure) {
            Structure s = (Structure)((Object)var);
            for (Variable variable : s.getVariables()) {
                VariableEnhanced nestedV = (VariableEnhanced)((Object)variable);
                varElem.addContent(this.writeVariable(nestedV));
            }
        }
        return varElem;
    }

    public static Element writeValues(VariableEnhanced v, Namespace ns, boolean allowRegular) {
        Array a;
        Element elem = new Element("values", ns);
        StringBuilder buff = new StringBuilder();
        try {
            a = v.read();
        }
        catch (IOException ioe) {
            return elem;
        }
        if (v.getDataType() == DataType.CHAR) {
            char[] data = (char[])a.getStorage();
            elem.setText(new String(data));
        } else if (v.getDataType() == DataType.STRING) {
            IndexIterator iter = a.getIndexIterator();
            int count = 0;
            while (iter.hasNext()) {
                String s = (String)iter.getObjectNext();
                if (count++ > 0) {
                    buff.append(" ");
                }
                buff.append("\"").append(s).append("\"");
            }
            elem.setText(buff.toString());
        } else {
            if (allowRegular && a.getRank() == 1 && a.getSize() > 2L) {
                Index ima = a.getIndex();
                double start = a.getDouble(ima.set(0));
                double incr = a.getDouble(ima.set(1)) - start;
                boolean isRegular = true;
                int i = 2;
                while ((long)i < a.getSize()) {
                    double v0;
                    double v1 = a.getDouble(ima.set(i));
                    if (!Misc.closeEnough(v1 - (v0 = a.getDouble(ima.set(i - 1))), incr)) {
                        isRegular = false;
                    }
                    ++i;
                }
                if (isRegular) {
                    elem.setAttribute("start", Double.toString(start));
                    elem.setAttribute("increment", Double.toString(incr));
                    elem.setAttribute("npts", Long.toString(v.getSize()));
                    return elem;
                }
            }
            boolean isRealType = v.getDataType() == DataType.DOUBLE || v.getDataType() == DataType.FLOAT;
            IndexIterator iter = a.getIndexIterator();
            buff.append(isRealType ? iter.getDoubleNext() : (double)iter.getIntNext());
            while (iter.hasNext()) {
                buff.append(" ");
                buff.append(isRealType ? iter.getDoubleNext() : (double)iter.getIntNext());
            }
            elem.setText(buff.toString());
        }
        return elem;
    }

    public static void main(String[] arg) {
        String test = "http://testbedapps.sura.org/thredds/dodsC/shelf_hypoxia_scan/noaa/NGOM/GOMUD-2009.3.182.3D.nc";
        String urls = arg.length == 0 ? test : arg[0];
        try {
            NetcdfDataset df = NetcdfDataset.openDataset(urls);
            NcMLWriter writer = new NcMLWriter();
            System.out.println("NetcdfDataset = " + urls + "\n" + df);
            System.out.println("-----------");
            writer.writeXML(df, System.out, null);
        }
        catch (Exception ioe) {
            System.out.println("error = " + urls);
            ioe.printStackTrace();
        }
    }
}

