/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.ConnectionUtils;
import com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public final class EC2CredentialsUtils {
    private static final Log LOG = LogFactory.getLog(EC2CredentialsUtils.class);
    private static EC2CredentialsUtils instance;
    private final ConnectionUtils connectionUtils;

    private EC2CredentialsUtils() {
        this(ConnectionUtils.getInstance());
    }

    EC2CredentialsUtils(ConnectionUtils connectionUtils) {
        this.connectionUtils = connectionUtils;
    }

    public static EC2CredentialsUtils getInstance() {
        if (instance == null) {
            instance = new EC2CredentialsUtils();
        }
        return instance;
    }

    public String readResource(URI endpoint) throws IOException {
        return this.readResource(endpoint, CredentialsEndpointRetryPolicy.NO_RETRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readResource(URI endpoint, CredentialsEndpointRetryPolicy retryPolicy) throws IOException {
        int retriesAttempted = 0;
        InputStream inputStream = null;
        while (true) {
            block9: {
                int statusCode;
                HttpURLConnection connection;
                block8: {
                    connection = this.connectionUtils.connectToEndpoint(endpoint);
                    statusCode = connection.getResponseCode();
                    if (statusCode != 200) break block8;
                    inputStream = connection.getInputStream();
                    String string = IOUtils.toString(inputStream);
                    IOUtils.closeQuietly(inputStream, LOG);
                    return string;
                }
                try {
                    if (statusCode == 404) {
                        throw new SdkClientException("The requested metadata is not found at " + connection.getURL());
                    }
                    if (retryPolicy.shouldRetry(retriesAttempted++, CredentialsEndpointRetryParameters.builder().withStatusCode(statusCode).build())) break block9;
                    inputStream = connection.getErrorStream();
                    this.handleErrorResponse(inputStream, statusCode, connection.getResponseMessage());
                }
                catch (IOException ioException) {
                    try {
                        if (!retryPolicy.shouldRetry(retriesAttempted++, CredentialsEndpointRetryParameters.builder().withException(ioException).build())) {
                            throw ioException;
                        }
                        LOG.debug("An IOException occured when connecting to service endpoint: " + endpoint + "\n Retrying to connect again.");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream, LOG);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(inputStream, LOG);
                    continue;
                }
            }
            IOUtils.closeQuietly(inputStream, LOG);
            continue;
            break;
        }
    }

    private void handleErrorResponse(InputStream errorStream, int statusCode, String responseMessage) throws IOException {
        String errorCode = null;
        if (errorStream != null) {
            String errorResponse = IOUtils.toString(errorStream);
            try {
                JsonNode node = Jackson.jsonNodeOf(errorResponse);
                JsonNode code = node.get("code");
                JsonNode message = node.get("message");
                if (code != null && message != null) {
                    errorCode = code.asText();
                    responseMessage = message.asText();
                }
            }
            catch (Exception exception) {
                LOG.debug("Unable to parse error stream");
            }
        }
        AmazonServiceException ase = new AmazonServiceException(responseMessage);
        ase.setStatusCode(statusCode);
        ase.setErrorCode(errorCode);
        throw ase;
    }
}

