/*
 * Decompiled with CFR 0.152.
 */
package opendap.servers;

import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.NoSuchFunctionException;
import opendap.servers.BTFunction;
import opendap.servers.BTFunctionClause;
import opendap.servers.BoolFunction;
import opendap.servers.BoolFunctionClause;
import opendap.servers.DAP2ServerSideException;
import opendap.servers.DereferenceClause;
import opendap.servers.FunctionLibrary;
import opendap.servers.RelOpClause;
import opendap.servers.SubClause;
import opendap.servers.TopLevelClause;
import opendap.servers.ValueClause;

public class ClauseFactory {
    protected FunctionLibrary functionLibrary;

    public ClauseFactory() {
        this.functionLibrary = new FunctionLibrary();
    }

    public ClauseFactory(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public TopLevelClause newRelOpClause(int operator, SubClause lhs, List rhs) throws DAP2ServerSideException {
        return new RelOpClause(operator, lhs, rhs);
    }

    public TopLevelClause newBoolFunctionClause(String functionName, List children) throws DAP2ServerSideException, NoSuchFunctionException {
        BoolFunction function = this.functionLibrary.getBoolFunction(functionName);
        if (function == null) {
            if (this.functionLibrary.getBTFunction(functionName) != null) {
                throw new NoSuchFunctionException("The function " + functionName + "() does not return a boolean value, and must be used in a comparison or as an argument to another function.");
            }
            throw new NoSuchFunctionException("This server does not support a " + functionName + "() function");
        }
        return new BoolFunctionClause(function, children);
    }

    public SubClause newValueClause(BaseType value, boolean constant) throws DAP2ServerSideException {
        return new ValueClause(value, constant);
    }

    public SubClause newBTFunctionClause(String functionName, List children) throws DAP2ServerSideException, NoSuchFunctionException {
        BTFunction function = this.functionLibrary.getBTFunction(functionName);
        if (function == null) {
            if (this.functionLibrary.getBoolFunction(functionName) != null) {
                throw new NoSuchFunctionException("The function " + functionName + "() cannot be used as a sub-expression in a constraint clause");
            }
            throw new NoSuchFunctionException("This server does not support a " + functionName + "() function");
        }
        return new BTFunctionClause(function, children);
    }

    public SubClause newDereferenceClause(String url) throws DAP2ServerSideException {
        return new DereferenceClause(url);
    }
}

