/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.GetSize;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMetaInfo
extends Operation {
    final Logger logger = LoggerFactory.getLogger(GetSize.class);
    public String file_separator = "/";

    public SetMetaInfo(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.backendType);
        try {
            tm.setFileProperty(this.bucket, myFile.getGenericPropertyField(), myFile.getGenericPropertyValue());
        }
        catch (Exception e) {
            tm.close();
            e.printStackTrace();
            throw new RemoteBackendException(" Error in SetMetaInfo operation ", e.getCause());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" PATH " + this.bucket);
        }
        return "1";
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remotePath: " + remotePath);
        }
        String buck = null;
        boolean isId = ObjectId.isValid(remotePath);
        if (!isId) {
            this.bucket = buck = new BucketCoding().bucketFileCoding(remotePath, rootArea);
            return this.bucket;
        }
        this.bucket = remotePath;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        throw new IllegalArgumentException("Input/Output stream is not compatible with getSize operation");
    }
}

