/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ewe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ewe.util.ExecUtils;
import org.gcube.dataanalysis.ewe.util.FileSystemUtils;
import org.gcube.dataanalysis.ewe.util.NetworkUtils;
import org.gcube.dataanalysis.ewe.util.ZipUtils;

public abstract class AbstractEwE
extends StandardLocalExternalAlgorithm {
    protected static String CONFIG_FILE_NAME = "run_config.xml";
    private String executionId;

    public void init() throws Exception {
        AnalysisLogger.getLogger().info((Object)"EwE Abstract Initialisation");
        this.executionId = UUID.randomUUID().toString();
    }

    public String getDescription() {
        String description = "Ecopath with Ecosim (EwE) is a free ecological/ecosystem modeling software suite. ";
        description = description + " This algorithm implementation expects a model and a configuration file as inputs; the result of the analysis is returned as a zip archive.";
        description = description + " References: Christensen, V., & Walters, C. J. (2004). Ecopath with Ecosim: methods, capabilities and limitations. Ecological modelling, 172(2), 109-139.";
        return description;
    }

    protected void setupWorkingDirectory() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils(this.executionId);
        AnalysisLogger.getLogger().debug((Object)("setting up working directory '" + fsu.getExecutionRoot() + "'"));
        fsu.ensureExecutionStructureExists();
    }

    protected abstract void prepareInput() throws Exception;

    protected void downloadAndSetupEwE() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Downloading EwE package");
        new NetworkUtils(this.executionId).downloadAndUnzipEwe();
    }

    protected void prepareOutput() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils(this.executionId);
        File outputZip = new File(this.config.getPersistencePath(), this.getOutputFileName());
        String binDir = fsu.getBinariesLocation().getAbsoluteFile().toString().substring(fsu.getExecutionRoot().getAbsoluteFile().toString().length() + 1);
        ZipUtils.zipFolder(fsu.getExecutionRoot(), outputZip, new String[]{binDir});
    }

    protected void removeWorkingDirectory() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Removing working directory");
        FileSystemUtils fsu = new FileSystemUtils(this.executionId);
        fsu.removeExecutionStructure();
    }

    protected void process() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils(this.executionId);
        this.setupWorkingDirectory();
        this.prepareInput();
        this.downloadAndSetupEwE();
        String command = String.format("mono %s/EwECmd.exe %s", fsu.getBinariesLocation(), CONFIG_FILE_NAME);
        AnalysisLogger.getLogger().debug((Object)("Executing '" + command + "'"));
        String log = ExecUtils.exec(command, fsu.getExecutionRoot());
        AnalysisLogger.getLogger().debug((Object)log);
        this.checkForErrors(fsu.getExecutionRoot());
        this.prepareOutput();
        this.removeWorkingDirectory();
    }

    public void shutdown() {
        AnalysisLogger.getLogger().info((Object)"Shutdown");
    }

    protected String getOutputFileName() {
        return "ewe-output-" + this.executionId + ".zip";
    }

    public StatisticalType getOutput() {
        String outputFileName = this.config.getPersistencePath() + "/" + this.getOutputFileName();
        PrimitiveType file = new PrimitiveType(File.class.getName(), (Object)new File(outputFileName), PrimitiveTypes.FILE, "OutputFile ", "An archive containing all output files");
        return file;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void checkForErrors(File executionRoot) throws Exception {
        File runLog = new File(executionRoot, "run_log.txt");
        FileInputStream fis = new FileInputStream(runLog);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        String line = null;
        Exception e = null;
        while ((line = br.readLine()) != null) {
            if (!"Ecopath model failed to load".equalsIgnoreCase(line)) continue;
            e = new Exception("Ecopath model failed to load");
        }
        br.close();
        if (e != null) {
            throw e;
        }
    }
}

