/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ewe.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ewe.util.FileSystemUtils;
import org.gcube.dataanalysis.ewe.util.ZipUtils;

public class NetworkUtils {
    private static String EWE_DOWNLOAD_URL = "http://goo.gl/hBc8UN";
    private String executionId;

    public NetworkUtils(String executionId) {
        this.executionId = executionId;
    }

    public URL getEweDownloadUrl() throws MalformedURLException {
        return new URL(EWE_DOWNLOAD_URL);
    }

    public void downloadAndUnzipEwe() throws IOException {
        FileSystemUtils fsu = new FileSystemUtils(this.executionId);
        File destination = new File(fsu.getBinariesLocation(), "EwECmd.zip");
        this.download(this.getEweDownloadUrl(), destination);
        ZipUtils.unzipFile(destination, fsu.getBinariesLocation());
    }

    public void download(URL source, File destination) throws IOException {
        AnalysisLogger.getLogger().debug((Object)("Downloading '" + source.toString() + " to " + destination.getAbsolutePath() + "'"));
        FileUtils.copyURLToFile((URL)source, (File)destination);
        AnalysisLogger.getLogger().debug((Object)"Downloaded.");
    }
}

