/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ewe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;

class ZipArchive {
    private File root;
    private Collection<String> exclude;

    public ZipArchive(File root) {
        this.root = root;
        this.exclude = new ArrayList<String>();
    }

    public void exclude(String[] exclude) {
        for (String e : exclude) {
            AnalysisLogger.getLogger().debug((Object)("The zip file will NOT contain '" + e + "'"));
            this.exclude.add(e);
        }
    }

    private String generateZipEntry(String file) {
        if (file.equals(this.root.getAbsoluteFile().toString())) {
            return "";
        }
        return file.substring(this.root.getAbsoluteFile().toString().length() + 1, file.length());
    }

    private List<String> generateFileList(File node) {
        ArrayList<String> out = new ArrayList<String>();
        String zipEntry = this.generateZipEntry(node.getAbsoluteFile().toString());
        if (!this.exclude.contains(zipEntry)) {
            if (node.isFile()) {
                out.add(zipEntry);
            }
            if (node.isDirectory()) {
                String[] subNote;
                for (String filename : subNote = node.list()) {
                    out.addAll(this.generateFileList(new File(node, filename)));
                }
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)("Excluding " + zipEntry));
        }
        return out;
    }

    public void zipToFile(File zipFile) {
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            AnalysisLogger.getLogger().debug((Object)("Output to Zip : " + zipFile));
            for (String file : this.generateFileList(this.root)) {
                int len;
                AnalysisLogger.getLogger().debug((Object)("File Added : " + file));
                ZipEntry ze = new ZipEntry(file);
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(this.root + File.separator + file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
            AnalysisLogger.getLogger().debug((Object)"Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

