/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.statistical_manager_wps_algorithms.output;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.output.OutputManagement;
import org.gcube.dataanalysis.statistical_manager_wps_algorithms.utils.SMutils;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class OutputBuilderUtil {
    public final UUID SessionUID = UUID.randomUUID();
    public final String wpsLocation = System.getProperty("catalina.base") + "/webapps/wps/";
    protected InetAddress addr;
    private String algorithmId;

    public OutputBuilderUtil(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public GenericFileDataBinding getXmlFileDataBinding(ArrayList<OutputManagement> outputList) {
        GenericFileDataBinding res = null;
        try {
            String xml = this.getXml(outputList);
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            res = new GenericFileDataBinding(new GenericFileData((InputStream)is, "text/plain"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        return res;
    }

    public String getXml(ArrayList<OutputManagement> outputList) {
        StringBuilder sb = new StringBuilder();
        String result = new String();
        if (outputList != null) {
            int i = 0;
            for (OutputManagement out : outputList) {
                if (i == 0) {
                    sb.append("\n");
                }
                sb.append(out.getFormattedOutput());
                ++i;
            }
        } else {
            sb.append("computation failed");
        }
        return sb.toString();
    }

    public Map buildFileResults(String filename) {
        String result = "";
        String hostname = null;
        try {
            this.addr = InetAddress.getLocalHost();
            hostname = this.addr.getHostName();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving host name " + e.getCause(), e);
        }
        result = "http://" + hostname + ":8080/" + this.wpsLocation + this.SessionUID.toString() + filename;
        HashMap<String, LiteralStringBinding> resulthash = new HashMap<String, LiteralStringBinding>();
        resulthash.put("result", new LiteralStringBinding(result));
        return resulthash;
    }

    public String getResultPath() throws UnknownHostException {
        this.addr = InetAddress.getLocalHost();
        String hostname = this.addr.getHostName();
        return "http://" + hostname + ":8888/" + this.wpsLocation;
    }

    public File saveFileFromUrl(String url, String path) throws Exception {
        InputStream inputStream = SMutils.getStorageClientInputStream(url);
        byte[] bytes = new byte[3024];
        FileOutputStream outputStream = null;
        File result = new File(path);
        outputStream = new FileOutputStream(result);
        int read = 0;
        while ((read = inputStream.read(bytes)) != -1) {
            ((OutputStream)outputStream).write(bytes, 0, read);
        }
        System.out.println("Done!");
        if (inputStream != null) {
            inputStream.close();
        }
        if (outputStream != null) {
            ((OutputStream)outputStream).close();
        }
        return result;
    }
}

