/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.postgres.queries;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CopyFromCsv;
import org.gcube.common.dbinterface.tables.Table;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CopyFromCsvImpl
implements CopyFromCsv {
    private String query = "COPY <%TABLENAME%> <%COLUMNLIST%> FROM STDIN WITH CSV <%QUOTE%> <%ESCAPE%> <%ENCODING%>";
    private Table table;
    private char quoting;
    private char separator;
    private String encoding = null;
    private File file;
    private List<String> columnList = null;

    public void setTable(Table table) {
        this.table = table;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setQuoting(char quoting) {
        this.quoting = quoting;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setColumnList(List<String> columns) {
        this.columnList = columns;
    }

    public String getExpression() {
        String columnListTMP = "";
        if (this.columnList != null && this.columnList.size() > 0) {
            StringBuffer bufferTMP = new StringBuffer("(");
            for (String column : this.columnList) {
                bufferTMP.append(column + ",");
            }
            columnListTMP = bufferTMP.substring(0, bufferTMP.length() - 1) + ")";
        }
        String encondingTMP = "";
        if (this.encoding != null) {
            encondingTMP = "ENCODING '" + this.encoding + "'";
        }
        String quoteTMP = "QUOTE '" + this.quoting + "'";
        String escapeTMP = "ESCAPE '" + this.separator + "'";
        return this.query.replace("<%TABLENAME%>", this.table.getTableName()).replace("<%QUOTE%>", quoteTMP).replace("<%ESCAPE%>", escapeTMP).replace("<%ENCODING%>", encondingTMP).replace("<%COLUMNLIST%>", columnListTMP);
    }

    public void execute(DBSession session) throws Exception {
        CopyManager copyManager = new CopyManager((BaseConnection)session.getConnection());
        FileReader fr = new FileReader(this.file);
        copyManager.copyIn(this.getExpression(), (Reader)fr);
        fr.close();
    }
}

