/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSInformationObjectResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSInformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSOIDResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSResponseConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSTreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.OIDResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.SMSResponseConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.TreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.util.RawContentLocationConverter;

public class WSToObjectResponseConverter {
    public static SMSResponseConfig convertToResponseConfig(WSResponseConfig wsResponseConfig) {
        if (wsResponseConfig.getOidResponse() != null) {
            return WSToObjectResponseConverter.convertToOIDResponse(wsResponseConfig.getOidResponse());
        }
        if (wsResponseConfig.getInformationObjectResponse() != null) {
            return WSToObjectResponseConverter.convertToInformationObjectResponse(wsResponseConfig.getInformationObjectResponse());
        }
        if (wsResponseConfig.getInformationObjectTreeResponse() != null) {
            return WSToObjectResponseConverter.convertToInformationObjectTreeResponse(wsResponseConfig.getInformationObjectTreeResponse());
        }
        throw new IllegalArgumentException("Impossible to convert the given WSResponseConfig");
    }

    protected static OIDResponse convertToOIDResponse(WSOIDResponse wsOIDResponse) {
        return new OIDResponse();
    }

    protected static InformationObjectResponse convertToInformationObjectResponse(WSInformationObjectResponse wsInformationObjectResponse) {
        List<StorageHint> hints = wsInformationObjectResponse.getStorageHints() == null ? Collections.emptyList() : Arrays.asList(wsInformationObjectResponse.getStorageHints());
        RawContentLocationConfig contentLocationConfig = RawContentLocationConverter.convertToRawContentLocationConfig(wsInformationObjectResponse.getContentLocation());
        return new InformationObjectResponse(contentLocationConfig, hints);
    }

    public static InformationObjectTreeResponse convertToInformationObjectTreeResponse(WSInformationObjectTreeResponse wsInformationObjectTreeResponse) {
        List<StorageHint> hints = wsInformationObjectTreeResponse.getStorageHints() == null ? Collections.emptyList() : Arrays.asList(wsInformationObjectTreeResponse.getStorageHints());
        List<TreeWalkRule> walkRules = wsInformationObjectTreeResponse.getWalkRules() == null ? Collections.emptyList() : WSToObjectResponseConverter.convertWsTreeWalkRules(wsInformationObjectTreeResponse.getWalkRules());
        RawContentLocationConfig contentLocationConfig = RawContentLocationConverter.convertToRawContentLocationConfig(wsInformationObjectTreeResponse.getContentLocation());
        return new InformationObjectTreeResponse(contentLocationConfig, walkRules, wsInformationObjectTreeResponse.getHops(), hints);
    }

    protected static List<TreeWalkRule> convertWsTreeWalkRules(WSTreeWalkRule[] rules) {
        LinkedList<TreeWalkRule> convertedRules = new LinkedList<TreeWalkRule>();
        for (WSTreeWalkRule rule : rules) {
            convertedRules.add(WSToObjectResponseConverter.convertWsTreeWalkRule(rule));
        }
        return convertedRules;
    }

    protected static TreeWalkRule convertWsTreeWalkRule(WSTreeWalkRule rule) {
        return new TreeWalkRule(rule.getRole(), rule.getSecondaryRole());
    }
}

