/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws;

import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.common.scope.api.ScopeProvider;

public class GCoreJAXWSHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String SCOPE_NS = "http://gcube-system.org/namespaces/scope";
    public static final String SCOPE_HEADER_NAME = "scope";
    public static final QName SCOPE_QNAME = new QName("http://gcube-system.org/namespaces/scope", "scope");
    public static final String SERVICECLASS_HEADER_NAME = "serviceClass";
    public static final QName SERVICECLASS_QNAME = new QName("http://gcube-system.org/namespaces/scope", "serviceClass");
    public static final String SERVICENAME_HEADER_NAME = "serviceName";
    public static final QName SERVICENAME_QNAME = new QName("http://gcube-system.org/namespaces/scope", "serviceName");
    public static final String CALLER_HEADER_NAME = "caller";
    public static final String CALLER_NS = "http://gcube-system.org/namespaces/caller";
    public static final QName CALLER_QNAME = new QName("http://gcube-system.org/namespaces/caller", "caller");
    private final GCoreService<?> target;

    GCoreJAXWSHandler(GCoreService<?> target) {
        this.target = target;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound.booleanValue()) {
            try {
                SOAPHeader header = context.getMessage().getSOAPPart().getEnvelope().getHeader();
                if (header == null) {
                    header = context.getMessage().getSOAPPart().getEnvelope().addHeader();
                }
                this.addCurrentScope(header);
                this.addTargetServiceCoordinates(header);
                this.addClientIdentity(header);
                this.correctWSAddressingHeader(header);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot configure outgoing message", e);
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    private void addClientIdentity(SOAPHeader header) throws Exception {
        this.addHeader(header, CALLER_QNAME, this.target.clientId());
    }

    private void addTargetServiceCoordinates(SOAPHeader header) throws Exception {
        this.addHeader(header, SERVICECLASS_QNAME, this.target.gcubeClass());
        this.addHeader(header, SERVICENAME_QNAME, this.target.gcubeName());
    }

    private void addCurrentScope(SOAPHeader header) throws Exception {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            throw new IllegalStateException("no scope is defined for this call");
        }
        this.addHeader(header, SCOPE_QNAME, scope);
    }

    private void correctWSAddressingHeader(SOAPHeader header) throws Exception {
        Iterator it = header.examineAllHeaderElements();
        while (it.hasNext()) {
            SOAPHeaderElement e = (SOAPHeaderElement)it.next();
            if (!e.getElementQName().getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) continue;
            e.detachNode();
            this.addHeader(header, new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", e.getElementQName().getLocalPart()), e.getTextContent());
        }
    }

    private void addHeader(SOAPHeader header, QName name, String value) throws Exception {
        header.addHeaderElement(name).addTextNode(value);
    }
}

