/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.layerindependent.descriptions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BasicStorageHints {
    public static final String HINT = "contentmanagement:hint";
    public static final String HINT_NAME_READING_START_OFFSET = "start-reading-at-byte-position";
    public static final String HINT_NAME_LIMIT_CONTENT_LENGTH_READ = "read-at-most-bytes";
    public static final String HINT_NAME_PREFERRED_BUFFER_SIZE = "preferred-buffer-size";
    public static final String HINT_NAME_USERNAME = "user";
    public static final String HINT_NAME_PASSWORD = "passwd";
    public static final String HINT_NAME_DELEGATED_CREDENTIALS = "delegated-credentials";
    public static final String HINT_NAME_INITIATED_BY = "initiated-by";
    public static final String HINT_NAME_IMPORT_VIRTUALLY = "keep-raw-content-external";
    public static final String HINT_NAME_DELETE_AFTER_TRANSFER = "delete-after-transfer";
    public static final String HINT_NAME_TRANSFER_CONTENT_IF_UPDATED_AFTER = "do-not-transfer-if-no-update-since";
    public static final String HINT_NAME_SMALL_FILES_IN_MESSAGE = "send-small-files-in-message";
    public static final String HINT_NAME_SMALL_FILES_SIZE = "small-files-threshold";
    public static final String HINT_NAME_IS_LARGE_FILE = "is-large-file";
    public static final String HINT_NAME_DO_NOT_REGISTER_FILE_IN_CATALOG = "do-not-register";
    public static final String HINT_NAME_CATALOG_FILE_NAME = "catalog-file-name";
    public static final String HINT_NAME_APPEND_CONTENT = "append-content";
    public static final String HINT_NAME_APPEND_NAME_TO_LOCATION = "append-name-to-location";
    public static final String HINT_NAME_APPEND_OID_TO_LOCATION = "append-objectid-to-location";
    public static final String HINT_NAME_NEW_FILE_INSTEAD_OF_REPLACEMENT = "create-new-file-when-file-exists";
    public static final String HINT_NAME_CONTENT_MIMETYPE = "content-mime-type";
    public static final String HINT_NAME_DO_NOT_UPDATE_CONTENT_MIMETYPE = "do-not-update-content-mime-type";
    public static final String HINT_NAME_GUESS_CONTENT_MIMETYPE = "guess-content-mime-type";
    public static final String HINT_NAME_CONTENT_LOCATION = "content-stored-at";
    public static final String HINT_NAME_BYTES_TRANSFERRED = "bytes-transferred";
    public static final String HINT_NAME_ELAPSED_TRANSFER_TIME = "elapsed-transfer-time";
    public static final String HINT_NAME_RETURN_NO_HINTS = "do-not-return-hints";
    public static final String HINT_NAME_RETURN_PLAIN_OBJECT = "return-plain-object";
    public static final String HINT_NAME_RETURN_OBJECT_WITHOUT_REFERENCES = "return-object-without-references";
    public static final String HINT_NAME_REACHED_MAX_RECURSION_DEPTH = "max-recursion-depth-reached";
    public static final String HINT_NAME_OBJECT_ALREADY_VISITED = "object-visited-before";
    public static final String HINT_NAME_PREDEFINED_ID = "use-predefined-id";
    public static final String HINT_NAME_ERROR_MESSAGE = "error-message";
    public static final String HINT_NAME_WARNING = "warning";
    public static final String HINT_NAME_ACCESS_METHOD = "access-method";
    public static final String HINT_VALUE_ACCESS_METHOD_HTTP_GET = "GET";
    public static final String HINT_VALUE_ACCESS_METHOD_HTTP_POST = "POST";
    public static final String HINT_VALUE_ACCESS_METHOD_HTTP_HEAD = "HEAD";
    public static final String VALUE_SEPARATOR = " ; ";
    private static final int NOT_FOUND = -1;
    public static final String HINT_VALUE_FALSE = Boolean.FALSE.toString();
    public static final String HINT_VALUE_TRUE = Boolean.TRUE.toString();
    @Deprecated
    public static final BasicStorageHints NO_HINTS = new BasicStorageHints(){

        public String getHintValue(String name) {
            return null;
        }

        public boolean hasHint(String name) {
            return false;
        }

        public void addHint(String name, String value) {
            assert (false) : "Cannot add hint to NO_HINTS!";
        }

        public String toString() {
            return "No hints.";
        }
    };
    protected Map hints = new HashMap();
    protected Set consumed = new HashSet();

    public void addHint(String name, String value) {
        this.hints.put(name, value);
    }

    public void addConsumedHint(String name, String value) {
        this.hints.put(name, value);
        this.markHint(name, true);
    }

    public String getHintValue(String name) {
        return (String)this.hints.get(name);
    }

    public String getHintValue(String name, String defaultValue) {
        String result = this.getHintValue(name);
        return result == null ? defaultValue : result;
    }

    public String consumeHint(String name, boolean onlyPreviouslyUnconsumed) {
        if (!this.hasHint(name) || onlyPreviouslyUnconsumed && this.isConsumedHint(name)) {
            return null;
        }
        String value = (String)this.hints.get(name);
        this.markHint(name, true);
        return value;
    }

    public String consumeHint(String name, boolean onlyPreviouslyUnconsumed, String defaultValue, boolean consumeDefault) {
        String result = this.consumeHint(name, onlyPreviouslyUnconsumed);
        if (result == null) {
            result = defaultValue;
            if (consumeDefault) {
                this.addConsumedHint(name, defaultValue);
            }
        }
        return result;
    }

    public Set getHintNames() {
        return this.hints.keySet();
    }

    public String removeHint(String name) {
        return (String)this.hints.remove(name);
    }

    public boolean hasHint(String name) {
        return this.hints.containsKey(name);
    }

    public boolean hasUnconsumedHint(String name) {
        return this.hints.containsKey(name) && !this.isConsumedHint(name);
    }

    public boolean hasConsumedHint(String name) {
        return this.hints.containsKey(name) && this.isConsumedHint(name);
    }

    public boolean isConsumedHint(String name) {
        assert (this.hasHint(name)) : "There is no such hint";
        return this.consumed.contains(name);
    }

    public boolean markHint(String name, boolean consumed) {
        assert (this.hints.containsKey(name)) : "No hint with name '" + name + "' exists, consumed flag could not be set to '" + consumed + "'!";
        return consumed ? this.consumed.add(name) : this.consumed.remove(name);
    }

    public BasicStorageHints getConsumedHints() {
        BasicStorageHints result = new BasicStorageHints();
        for (String name : this.consumed) {
            result.addHint(name, this.getHintValue(name));
            result.markHint(name, true);
        }
        return result;
    }

    public BasicStorageHints getUnconsumedHints() {
        BasicStorageHints result = new BasicStorageHints();
        for (String name : this.consumed) {
            if (this.isConsumedHint(name)) continue;
            result.addHint(name, this.getHintValue(name));
        }
        return result;
    }

    public int length() {
        return this.hints.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{ ");
        for (String name : this.hints.keySet()) {
            String value = this.getHintValue(name);
            sb.append("'");
            sb.append(name);
            sb.append("' = '");
            sb.append(value);
            if (this.isConsumedHint(name)) {
                sb.append("' (consumed), ");
                continue;
            }
            sb.append("', ");
        }
        if (sb.length() > 2) {
            sb.replace(sb.length() - 2, sb.length(), " }");
        } else {
            sb.append(" }");
        }
        return sb.toString();
    }

    public void addWarning(String message) {
        String oldWarning = this.getHintValue(HINT_NAME_WARNING);
        if (oldWarning == null) {
            this.addConsumedHint(HINT_NAME_WARNING, message);
        } else {
            this.addHint(HINT_NAME_WARNING, oldWarning.concat(VALUE_SEPARATOR).concat(message));
        }
    }

    public static String[] splitWarnings(String concatinatedWarningMessages) {
        if (concatinatedWarningMessages == null) {
            return null;
        }
        if (concatinatedWarningMessages.indexOf(VALUE_SEPARATOR) == -1) {
            return new String[]{concatinatedWarningMessages};
        }
        return concatinatedWarningMessages.split(VALUE_SEPARATOR);
    }

    public static String[] getWarings(BasicStorageHints h) {
        if (h == null) {
            return null;
        }
        return BasicStorageHints.splitWarnings(h.getHintValue(HINT_NAME_WARNING));
    }

    public String[] getWarnings() {
        return BasicStorageHints.splitWarnings(this.getHintValue(HINT_NAME_WARNING));
    }
}

