/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.coyote.valves;

import java.io.IOException;
import java.net.Socket;
import javax.servlet.ServletException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.globus.tomcat.catalina.net.HTTPSSocket;
import org.globus.tomcat.coyote.net.HTTPSConnector;
import org.ietf.jgss.GSSContext;

public final class HTTPSValve
extends ValveBase {
    protected static final String info = "org.globus.tomcat.catalina.valves.HTTPSTransportValve/1.0";

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        this.expose(request);
        context.invokeNext(request, response);
    }

    private HTTPSSocket getSocketFromInputStream(CoyoteRequest request) {
        InternalInputBuffer internalInputBuffer;
        InputBuffer inputBuffer = request.getCoyoteRequest().getInputBuffer();
        if (inputBuffer instanceof InternalInputBuffer && (internalInputBuffer = (InternalInputBuffer)inputBuffer).getInputStream() instanceof HTTPSSocket.SocketGSIGssInputStream) {
            HTTPSSocket.SocketGSIGssInputStream in = (HTTPSSocket.SocketGSIGssInputStream)((Object)internalInputBuffer.getInputStream());
            return in.getSocket();
        }
        return null;
    }

    private HTTPSSocket getSocketFromAttribute(CoyoteRequest request) {
        Socket socket = (Socket)request.getCoyoteRequest().getAttribute("SOCKET");
        return socket instanceof HTTPSSocket ? (HTTPSSocket)((Object)socket) : null;
    }

    protected void expose(Request request) {
        CoyoteRequest req = null;
        if (!(request instanceof CoyoteRequest) || !(request.getConnector() instanceof HTTPSConnector)) {
            return;
        }
        req = (CoyoteRequest)request;
        req.getCoyoteRequest().scheme().setString("https");
        HTTPSSocket socket = this.getSocketFromAttribute(req);
        if (socket == null && (socket = this.getSocketFromInputStream(req)) == null) {
            return;
        }
        String globusID = socket.getUserDN();
        if (globusID != null) {
            request.getRequest().setAttribute("org.globus.gsi.authorized.user.dn", (Object)globusID);
        }
        GSSContext context = socket.getContext();
        request.getRequest().setAttribute("org.globus.gsi.context", (Object)context);
    }
}

