/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class RecordDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<FieldDefinition> Fields = null;
    protected IBuffer.TransportDirective directive = IBuffer.TransportDirective.Inherit;

    public RecordDefinition() {
        this.Fields = new ArrayList<FieldDefinition>();
    }

    public RecordDefinition(List<FieldDefinition> fieldDefinitions) {
        this.Fields = fieldDefinitions;
    }

    public void copyFrom(RecordDefinition other) throws GRS2RecordSerializationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        other.deflate(new DataOutputStream(out));
        this.inflate(new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
    }

    public FieldDefinition getDefinition(int index) {
        return this.Fields.get(index);
    }

    public int getDefinition(String name) {
        int i = 0;
        for (FieldDefinition fd : this.Fields) {
            if (fd.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getDefinitionSize() {
        return this.Fields.size();
    }

    public void setTransportDirective(IBuffer.TransportDirective directive) {
        this.directive = directive;
    }

    public IBuffer.TransportDirective getTransportDirective() {
        return this.directive;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RecordDefinition)) {
            return false;
        }
        if (this.Fields.size() != ((RecordDefinition)obj).Fields.size()) {
            return false;
        }
        if (!this.directive.equals((Object)((RecordDefinition)obj).directive)) {
            return false;
        }
        for (FieldDefinition thisField : this.Fields) {
            boolean found = false;
            for (FieldDefinition otherField : ((RecordDefinition)obj).Fields) {
                if (!thisField.equals(otherField)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return this.extendEquals(obj);
    }

    public abstract boolean extendEquals(Object var1);

    public void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.directive.toString());
            out.writeInt(this.Fields.size());
            for (FieldDefinition def : this.Fields) {
                out.writeUTF(def.getClass().getName());
                def.deflate(out);
            }
            this.extendDeflate(out);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete marshalling of definition", ex);
        }
    }

    public final Element toXML(Document doc) throws GRS2RecordSerializationException, GRS2RecordDefinitionException, DOMException {
        Element element = doc.createElement("recordDefinition");
        Element elm = null;
        elm = doc.createElement("directive");
        elm.setTextContent(String.valueOf(this.directive.toString()));
        element.appendChild(elm);
        Element fieldDefinitions = doc.createElement("fields");
        for (FieldDefinition def : this.Fields) {
            Element fieldDefinition = def.toXML(doc);
            Element fieldDefinitionClass = doc.createElement("fieldDefinitionClass");
            fieldDefinitionClass.setTextContent(def.getClass().getName());
            fieldDefinition.appendChild(fieldDefinitionClass);
            fieldDefinitions.appendChild(fieldDefinition);
        }
        this.extendToXML(element);
        element.appendChild(fieldDefinitions);
        return element;
    }

    public final void fromXML(Element element) throws GRS2RecordSerializationException, GRS2RecordDefinitionException, DOMException {
        try {
            this.directive = IBuffer.TransportDirective.valueOf(element.getElementsByTagName("directive").item(0).getTextContent());
            NodeList fieldList = element.getElementsByTagName("fields").item(0).getChildNodes();
            int fieldsLength = fieldList.getLength();
            this.Fields = new ArrayList<FieldDefinition>();
            for (int i = 0; i < fieldsLength; ++i) {
                Element fieldDefinition = (Element)fieldList.item(i);
                String fieldDefType = fieldDefinition.getElementsByTagName("fieldDefinitionClass").item(0).getTextContent();
                FieldDefinition def = (FieldDefinition)Class.forName(fieldDefType).newInstance();
                def.fromXML(fieldDefinition);
                this.Fields.add(def);
            }
            this.extendFromXML(element);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete unmarshalling of definition", ex);
        }
    }

    public abstract void extendDeflate(DataOutput var1) throws GRS2RecordSerializationException;

    public void inflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.directive = IBuffer.TransportDirective.valueOf(in.readUTF());
            int fieldsLength = in.readInt();
            this.Fields = new ArrayList<FieldDefinition>();
            for (int i = 0; i < fieldsLength; ++i) {
                String fieldDefType = in.readUTF();
                FieldDefinition def = (FieldDefinition)Class.forName(fieldDefType).newInstance();
                def.inflate(in);
                this.Fields.add(def);
            }
            this.extendInflate(in);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete unmarshalling of definition", ex);
        }
    }

    public abstract void extendInflate(DataInput var1) throws GRS2RecordSerializationException;

    public abstract void extendFromXML(Element var1) throws GRS2RecordSerializationException;

    public abstract void extendToXML(Element var1) throws GRS2RecordSerializationException;
}

