/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.container.Semaphore;
import org.globus.wsrf.container.ServiceRequest;

public class ServiceRequestQueue {
    LinkedList requests = new LinkedList();
    int waitingThreads = 0;
    static Log logger = LogFactory.getLog((String)ServiceRequestQueue.class.getName());
    private Semaphore semaphore = new Semaphore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRequest dequeue() throws InterruptedException {
        this.addWaitingThread();
        this.semaphore.waitForSignal();
        this.removeWaitingThread();
        logger.debug((Object)"Getting request from queue");
        Object request = null;
        ServiceRequestQueue serviceRequestQueue = this;
        synchronized (serviceRequestQueue) {
            request = this.requests.removeFirst();
        }
        return request;
    }

    private synchronized void addWaitingThread() {
        ++this.waitingThreads;
    }

    private synchronized void removeWaitingThread() {
        --this.waitingThreads;
    }

    public synchronized int enqueue(ServiceRequest request) {
        logger.debug((Object)"Putting request in queue");
        this.requests.addLast(request);
        this.semaphore.sendSignal();
        return this.waitingThreads;
    }

    public synchronized void stopThreads(int threads) {
        for (int i = 0; i < threads; ++i) {
            this.requests.addFirst(null);
            this.semaphore.sendSignal();
        }
    }
}

