/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StubCache {
    private static final Logger log = LoggerFactory.getLogger(StubCache.class);
    private volatile LRUCache cache = new LRUCache();
    private ConcurrentHashMap<QName, Lock> nameLocks = new ConcurrentHashMap();

    StubCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(QName name) {
        Lock nameLock = this.lockFor(name);
        try {
            this.cache.remove(name);
        }
        finally {
            nameLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Service get(QName name, Callable<Service> task) {
        Lock nameLock = this.lockFor(name);
        nameLock.lock();
        try {
            Service service = (Service)this.cache.get(name);
            if (service == null) {
                try {
                    service = task.call();
                    log.trace("caching stub for " + name);
                    this.cache.put(name, service);
                }
                catch (Exception e) {
                    throw new RuntimeException("could not build service", e);
                }
            } else {
                log.trace("using cached stub for " + name);
            }
            Service service2 = service;
            return service2;
        }
        finally {
            nameLock.unlock();
        }
    }

    private Lock lockFor(QName name) {
        Lock nameLock = this.nameLocks.get(name);
        if (nameLock == null) {
            ReentrantLock newLock = new ReentrantLock();
            nameLock = this.nameLocks.putIfAbsent(name, newLock);
            nameLock = nameLock == null ? newLock : nameLock;
        }
        return nameLock;
    }

    private class LRUCache
    extends LinkedHashMap<QName, Service> {
        private static final long serialVersionUID = 1L;
        public static final int max = 50;

        public LRUCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<QName, Service> eldest) {
            if (this.size() >= 50) {
                StubCache.this.nameLocks.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    }
}

