/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.gar;

import java.io.File;
import org.globus.ant.AntTaskLauncher;
import org.globus.tools.gar.DeployGar;

public class UndeployGar
extends AntTaskLauncher {
    private static final String USAGE = "globus-undeploy-gar <gar id> [options]\nOptions:\n  -help, -h             Print this message\n  -verbose, -v          Enable verbose mode\n  -debug, -d            Enable debug mode\n  -D<property>=<value>  Pass arbitrary property value\n";

    public static void main(String[] args) {
        String globusLocation = System.getProperty("GLOBUS_LOCATION");
        if (globusLocation == null) {
            System.err.println("Error: GLOBUS_LOCATION system property is not set");
            System.exit(1);
        }
        if (args.length == 0 || args.length == 1 && (args[0].equals("-h") || args[0].equalsIgnoreCase("-help"))) {
            System.err.println(USAGE);
            System.exit(3);
        }
        File globusLocationFile = new File(globusLocation);
        File buildFile = new File(globusLocation, "share/globus_wsrf_common/build-packages.xml");
        DeployGar deploy = new DeployGar();
        deploy.setProperty("env.GLOBUS_LOCATION", globusLocationFile.getAbsolutePath());
        deploy.setProperty("gar.id", args[0]);
        deploy.setStartMessage("Undeploying gar...");
        deploy.setFinishSuccessMessage("Undeploy successful");
        deploy.setFinishFailMessage("Undeploy failed");
        int mode = 2;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("-D")) {
                String name = args[i].substring(2, args[i].length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length - 1) {
                    value = args[++i];
                } else {
                    System.err.println("Error: Missing value for property " + name);
                    System.exit(2);
                }
                deploy.setProperty(name, value);
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equals("-h")) {
                System.err.println(USAGE);
                System.exit(3);
                continue;
            }
            if (args[i].equalsIgnoreCase("-verbose") || args[i].equals("-v")) {
                mode = 3;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug") || args[i].equals("-d")) {
                mode = 4;
                continue;
            }
            System.err.println("Error: Unknown argument: " + args[i]);
            System.exit(2);
        }
        deploy.setOutputLevel(mode);
        deploy.executeTarget(buildFile, "undeployGar");
    }
}

