/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.informationsystem.publisher;

import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;

public interface ISLocalPublisher {
    public void subscribeLocalProfileEvents(LocalProfileConsumer var1) throws ISPublisherException;

    public boolean isEnabled(String var1, GCUBEScope var2);

    public static class GCUBEResourceMessage {
        private GCUBEResource resource = null;
        private String ID;
        private String type;
        private GCUBEScope scope;

        GCUBEResourceMessage(GCUBEResource resource, GCUBEScope scope) {
            this.resource = resource;
            this.ID = this.resource.getID();
            this.type = this.resource.getType();
            this.scope = scope;
        }

        GCUBEResourceMessage(String resourceID, String type, GCUBEScope scope) {
            this.ID = resourceID;
            this.type = type;
            this.scope = scope;
        }

        GCUBEResource getResource() {
            return this.resource;
        }

        String getID() {
            return this.ID;
        }

        String getType() {
            return this.type;
        }

        GCUBEScope getScope() {
            return this.scope;
        }
    }

    public static class LocalProfileConsumer
    implements GCUBEConsumer<LocalProfileTopic, Object> {
        @Override
        public <T extends LocalProfileTopic, P> void onEvent(GCUBEEvent<T, P> ... events) {
            if (events == null) {
                return;
            }
            block5: for (GCUBEEvent<T, P> event : events) {
                LocalProfileTopic topic = (LocalProfileTopic)event.getTopic();
                GCUBEResourceMessage message = (GCUBEResourceMessage)((LocalProfileEvent)event).getPayload();
                switch (topic) {
                    case REGISTERED: {
                        this.onProfileRegistered(message.getResource(), message.getScope());
                        continue block5;
                    }
                    case UPDATED: {
                        this.onProfileUpdated(message.getResource(), message.getScope());
                        continue block5;
                    }
                    case REMOVED: {
                        this.onProfileRemoved(message.getID(), message.getType(), message.getScope());
                    }
                }
            }
        }

        protected void onProfileRemoved(String resourceID, String type, GCUBEScope scope) {
        }

        protected void onProfileUpdated(GCUBEResource resource, GCUBEScope scope) {
        }

        protected void onProfileRegistered(GCUBEResource resource, GCUBEScope scope) {
        }
    }

    public static class LocalProfileEvent
    extends GCUBEEvent<LocalProfileTopic, GCUBEResourceMessage> {
        public LocalProfileEvent(GCUBEResource resource, GCUBEScope scope) {
            this.payload = new GCUBEResourceMessage(resource, scope);
        }

        public LocalProfileEvent(String resourceID, String type, GCUBEScope scope) {
            this.payload = new GCUBEResourceMessage(resourceID, type, scope);
        }
    }

    public static enum LocalProfileTopic implements GCUBETopic
    {
        REGISTERED,
        UPDATED,
        REMOVED;

    }
}

