/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.persistence.GCUBERIPersistenceManager;
import org.gcube.common.core.persistence.GCUBERIPersistenceManagerProfile;

public abstract class GCUBERIFilePersistenceManager
extends GCUBERIPersistenceManager {
    private File stateFile;
    private static byte[] buffer = new byte[8192];

    public GCUBERIFilePersistenceManager(GCUBEServiceContext ctxt, GCUBERIPersistenceManagerProfile profile) {
        super(ctxt, profile);
    }

    @Override
    protected void commitState() throws Exception {
        this.packageState();
        this.storeState();
    }

    @Override
    protected void recoverState() throws GCUBERIPersistenceManager.StateNotFoundException, Exception {
        if (!this.isEmpty(this.ctxt.getPersistenceRoot())) {
            this.logger.info("local state is not empty, retaining it");
            return;
        }
        this.loadState();
        this.unpackageState();
    }

    private boolean isEmpty(File dir) {
        return this.getState(dir, new List[0]).size() > 0;
    }

    protected List<File> getState(File dir, List<File> ... files) {
        if (files.length == 0) {
            files = new List[]{new ArrayList()};
        }
        if (dir.exists()) {
            for (File f : dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return GCUBERIFilePersistenceManager.this.isExclude(name);
                }
            })) {
                if (f.isFile()) {
                    files[0].add(f);
                    continue;
                }
                this.getState(f, files);
            }
        }
        return files[0];
    }

    public boolean isExclude(String name) {
        for (Pattern p : this.excludes) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    protected File getStateFile() throws IOException {
        if (this.stateFile == null) {
            this.stateFile = File.createTempFile(this.ctxt.getInstance().getID(), ".state");
        }
        return this.stateFile;
    }

    protected void packageState() throws Exception {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.getStateFile())));
        this.packageState(this.getState(this.ctxt.getPersistenceRoot(), new List[0]), out);
        out.close();
    }

    private void packageState(List<File> files, ZipOutputStream zstream) throws Exception {
        int read = 0;
        for (File f : files) {
            FileInputStream in = new FileInputStream(f);
            ZipEntry entry = new ZipEntry(f.getPath().substring(this.ctxt.getPersistenceRoot().getPath().length() + 1));
            zstream.putNextEntry(entry);
            this.logger.debug("adding:" + entry.getName());
            while (-1 != (read = in.read(buffer))) {
                zstream.write(buffer, 0, read);
            }
            zstream.closeEntry();
            in.close();
        }
    }

    protected void unpackageState() throws Exception {
        ZipEntry entry;
        FileInputStream fileInputStream = new FileInputStream(this.getStateFile());
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
        while ((entry = zipInputStream.getNextEntry()) != null) {
            int count;
            File file = new File(this.ctxt.getPersistenceRoot(), entry.getName());
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((count = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                bufferedOutputStream.write(buffer, 0, count);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        zipInputStream.close();
    }

    protected abstract void loadState() throws GCUBERIPersistenceManager.StateNotFoundException, Exception;

    protected abstract void storeState() throws Exception;
}

