/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.state.store.registry;

import gr.uoa.di.madgik.commons.state.store.StateStoreInfo;
import gr.uoa.di.madgik.commons.state.store.registry.StateStoreRegistryKey;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateStoreRegistry {
    private static Logger logger = Logger.getLogger(StateStoreRegistry.class.getName());
    private Map<String, StateStoreRegistryKey> Dictionary = new Hashtable<String, StateStoreRegistryKey>();

    public Map<String, StateStoreRegistryKey> GetDictionary() {
        return this.Dictionary;
    }

    public Boolean Put(StateStoreRegistryKey Key, StateStoreInfo info) throws Exception {
        Boolean ret = true;
        if (this.Dictionary.containsKey(Key.GetKey())) {
            ret = false;
            StateStoreRegistryKey entry = this.Dictionary.get(Key.GetKey());
            if (entry.IsActive().booleanValue()) {
                ret = true;
            }
            this.Dictionary.put(Key.GetKey(), Key);
            entry = this.Dictionary.get(Key.GetKey());
            this.StoreUpdate(info, entry, false);
        } else {
            this.Dictionary.put(Key.GetKey(), Key);
            StateStoreRegistryKey entry = this.Dictionary.get(Key.GetKey());
            this.StoreUpdate(info, entry, false);
        }
        return ret;
    }

    public Boolean Contains(String Key) {
        return this.Dictionary.containsKey(Key);
    }

    public StateStoreRegistryKey Get(String Key) {
        if (!this.Dictionary.containsKey(Key)) {
            return null;
        }
        return this.Dictionary.get(Key);
    }

    public Boolean Delete(String Key, StateStoreInfo info) throws Exception {
        if (!this.Dictionary.containsKey(Key)) {
            return false;
        }
        StateStoreRegistryKey entry = this.Dictionary.get(Key);
        entry.Deactivate();
        this.StoreUpdate(info, entry, true);
        return true;
    }

    public void Deserialize(StateStoreInfo info) throws Exception {
        this.Dictionary.clear();
        if (info.GetEntryRegistryFile().exists() && info.GetEntryRegistryFile().isFile()) {
            DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(info.GetEntryRegistryFile())));
            this.Decode(din);
            if (info.GetEntryDataFile().exists() && info.GetEntryDataFile().isFile()) {
                if (this.Dictionary.size() == 0) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Registry entries were 0. Cleaning up");
                    }
                    this.CleanUp(info);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Registry entries seem valid. Keeping read state entries");
                }
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Could not find data file. Cleaning up");
                }
                this.CleanUp(info);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Could not find registry file. Cleaning up");
            }
            this.CleanUp(info);
        }
    }

    public File MoveToClean() throws Exception {
        File tmp = null;
        RandomAccessFile dout = null;
        try {
            tmp = File.createTempFile(UUID.randomUUID().toString(), ".madgik.state.registry.tmp");
            dout = new RandomAccessFile(tmp, "rw");
            this.Encode(dout);
            dout.close();
            return tmp;
        }
        catch (Exception ex) {
            try {
                if (dout != null) {
                    dout.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            try {
                if (tmp != null) {
                    tmp.delete();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            throw ex;
        }
    }

    public void StoreUpdate(StateStoreInfo info, StateStoreRegistryKey entry, boolean update) throws Exception {
        RandomAccessFile acc = null;
        try {
            acc = new RandomAccessFile(info.GetEntryRegistryFile(), "rw");
            acc.seek(0L);
            if (!update) {
                int entrycount = 0;
                if (info.GetEntryRegistryFile().length() > 0L) {
                    entrycount = acc.readInt();
                    acc.seek(0L);
                }
                acc.writeInt(entrycount + 1);
                acc.seek(info.GetEntryRegistryFile().length());
            } else {
                acc.seek(entry.GetStartingRegistryOffset());
            }
            entry.Encode(acc);
            acc.close();
        }
        catch (Exception ex) {
            if (acc != null) {
                acc.close();
            }
            throw ex;
        }
    }

    private void Decode(DataInputStream stream) throws Exception {
        int entryCount = stream.readInt();
        for (int i = 0; i < entryCount; ++i) {
            StateStoreRegistryKey entry = new StateStoreRegistryKey();
            entry.Decode(stream);
            if (!entry.IsActive().booleanValue()) continue;
            this.Dictionary.put(entry.GetKey(), entry);
        }
    }

    private void Encode(RandomAccessFile stream) throws Exception {
        int activeCount = 0;
        for (Map.Entry<String, StateStoreRegistryKey> key : this.Dictionary.entrySet()) {
            if (!key.getValue().IsActive().booleanValue()) continue;
            ++activeCount;
        }
        stream.seek(0L);
        stream.writeInt(activeCount);
        for (Map.Entry<String, StateStoreRegistryKey> key : this.Dictionary.entrySet()) {
            if (!key.getValue().IsActive().booleanValue()) continue;
            key.getValue().Encode(stream);
        }
    }

    private void CleanUp(StateStoreInfo info) {
        info.GetEntryDataFile().delete();
        info.GetEntryDataFile().delete();
        this.Dictionary.clear();
    }
}

