/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore.common;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlMixed;
import org.gcube.common.resources.gcore.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnyMixedWrapper {
    private Element root = Utils.newDocument().getDocumentElement();
    @XmlAnyElement
    @XmlMixed
    private List<Object> nodes;

    public Element root() {
        return this.root;
    }

    public String asString() {
        return this.root.getTextContent();
    }

    public void setString(String text) {
        this.root.appendChild(this.root.getOwnerDocument().createTextNode(text));
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.nodes != null) {
            boolean mixedContent = false;
            for (Object node : this.nodes) {
                if (!(node instanceof String) || ((String)String.class.cast(node)).matches("\\s*")) continue;
                mixedContent = true;
                break;
            }
            for (Object node : this.nodes) {
                if (node instanceof Element) {
                    this.root.appendChild(this.root.getOwnerDocument().adoptNode((Element)node));
                    continue;
                }
                if (!mixedContent) continue;
                this.root.appendChild(this.root.getOwnerDocument().createTextNode((String)node));
            }
        }
        this.nodes = null;
    }

    private void beforeMarshal(Marshaller marshaller) {
        this.nodes = new ArrayList<Object>();
        NodeList list = this.root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                this.nodes.add((Element)node);
                continue;
            }
            this.nodes.add(node.getTextContent());
        }
    }

    public String toString() {
        return "[element=" + this.root + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyMixedWrapper other = (AnyMixedWrapper)obj;
        if (this.root != null && other.root != null) {
            this.root.normalize();
            other.root.normalize();
        }
        return !(this.root == null ? other.root != null : !this.root.isEqualNode(other.root));
    }
}

