/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.client;

import java.util.List;
import javax.xml.rpc.Stub;
import org.apache.axis.encoding.AnyContentType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;

public class Query
extends BaseClient {
    private static final String FOOTER = "Where:\n  [expression] - query expression\n  [dialect]    - query dialect\n";

    public static void main(String[] args) {
        Query client = new Query();
        client.setCustomUsage("[expression] [dialect]");
        client.setHelpFooter(FOOTER);
        String dialect = "http://www.w3.org/TR/1999/REC-xpath-19991116";
        String expression = "/";
        try {
            CommandLine line = client.parse(args);
            List options = line.getArgList();
            if (options != null && !options.isEmpty()) {
                if (options.size() == 1) {
                    expression = (String)options.get(0);
                } else {
                    expression = (String)options.get(0);
                    dialect = (String)options.get(1);
                }
            }
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
        try {
            QueryExpressionType query = new QueryExpressionType();
            query.setDialect(dialect);
            query.setValue((Object)expression);
            QueryResourceProperties_PortType port = locator.getQueryResourcePropertiesPort(client.getEPR());
            client.setOptions((Stub)port);
            QueryResourceProperties_Element request = new QueryResourceProperties_Element();
            request.setQueryExpression(query);
            QueryResourcePropertiesResponse response = port.queryResourceProperties(request);
            if (response == null || response.get_any() == null || response.get_any().length == 0) {
                System.out.println("Query did not return any results.");
            } else {
                System.out.println(AnyHelper.toSingleString((AnyContentType)response));
            }
        }
        catch (Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
            System.exit(2);
        }
    }
}

