/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils.cache;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedNodeList {
    private Node head;
    private Node tail;
    private int size;

    public Node createNode() {
        return new Node();
    }

    public Node createNode(Object value) {
        return new Node(value);
    }

    public synchronized void moveToEnd(Node node) {
        if (node != this.tail) {
            this.remove(node);
            this.add(node);
        }
    }

    public int computeSize() {
        int i = 0;
        Node n = this.head;
        while (n != null) {
            n = n.next;
            ++i;
        }
        return i;
    }

    public Iterator reverseIterator() {
        return new NodeIterator(this.tail, false);
    }

    public Iterator iterator() {
        return new NodeIterator(this.head, true);
    }

    public synchronized void clear() {
        this.tail = null;
        this.head = null;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public int size() {
        return this.size;
    }

    public synchronized void add(Node node) {
        if (this.tail == null) {
            if (this.head != null) {
                throw new RuntimeException();
            }
            this.tail = this.head = node;
            node.next = null;
            node.previous = null;
        } else {
            Node newTail;
            if (this.tail.next != null) {
                throw new RuntimeException();
            }
            Node oldTail = this.tail;
            oldTail.next = newTail = node;
            newTail.next = null;
            newTail.previous = oldTail;
            this.tail = newTail;
        }
        ++this.size;
    }

    public Node getFirst() {
        return this.head == null ? null : this.head;
    }

    public Node getLast() {
        return this.tail == null ? null : this.tail;
    }

    public synchronized Node removeFirst() {
        if (this.head == null) {
            return null;
        }
        Node oldHead = this.head;
        this.remove(this.head);
        return oldHead;
    }

    public synchronized Node removeLast() {
        if (this.tail == null) {
            return null;
        }
        Node oldTail = this.tail;
        this.remove(this.tail);
        return oldTail;
    }

    public synchronized void remove(Node node) {
        Node nextNode = node.next;
        Node prevNode = node.previous;
        if (nextNode == null && prevNode == null) {
            if (node != this.tail && node != this.head) {
                throw new RuntimeException();
            }
            this.tail = null;
            this.head = null;
        } else if (nextNode != null && prevNode != null) {
            prevNode.next = nextNode;
            nextNode.previous = prevNode;
        } else if (nextNode != null && prevNode == null) {
            if (node != this.head) {
                throw new RuntimeException();
            }
            nextNode.previous = null;
            this.head = nextNode;
        } else if (nextNode == null && prevNode != null) {
            if (node != this.tail) {
                throw new RuntimeException();
            }
            prevNode.next = null;
            this.tail = prevNode;
        }
        --this.size;
        node.previous = null;
        node.next = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        Node n = this.head;
        if (n == null) {
            buf.append("<empty>");
        } else {
            while (n != null) {
                buf.append("[" + i + "]: ").append(n).append("\r\n");
                n = n.next;
                ++i;
            }
        }
        return buf.toString();
    }

    private static class NodeIterator
    implements Iterator {
        private Node currentNode;
        private boolean forward;

        public NodeIterator(Node startNode, boolean forward) {
            this.currentNode = startNode;
            this.forward = forward;
        }

        public boolean hasNext() {
            return this.currentNode != null;
        }

        public Object next() {
            Node node = this.currentNode;
            if (node == null) {
                throw new NoSuchElementException();
            }
            this.currentNode = this.forward ? this.currentNode.next : this.currentNode.previous;
            return node;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Node {
        Node next;
        Node previous;
        Object value;

        public Node() {
        }

        public Node(Object value) {
            this.value = value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public Node getNext() {
            return this.next;
        }

        public Node getPrevious() {
            return this.previous;
        }
    }
}

