/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.ac;

import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.glite.security.voms.ac.ACTrustStore;
import org.glite.security.voms.ac.AttributeCertificate;

public class ACValidator {
    protected static Logger log = Logger.getLogger((Class)ACValidator.class);
    private static ACValidator theInstance = null;
    protected ACTrustStore myTrustStore;

    public ACValidator(ACTrustStore trustStore) {
        if (trustStore == null) {
            throw new IllegalArgumentException("ACValidator: constructor must have an ACTrustStore");
        }
        this.myTrustStore = trustStore;
    }

    public static ACValidator getInstance() {
        return ACValidator.getInstance(null);
    }

    public static ACValidator getInstance(ACTrustStore trustStore) {
        theInstance = theInstance != null ? theInstance : new ACValidator(trustStore);
        return theInstance;
    }

    public boolean validate(AttributeCertificate ac) {
        if (ac == null) {
            return false;
        }
        if (!ac.isValid()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AC expired or not yet valid. Issuer : " + ac.getIssuer().getName()));
            }
            return false;
        }
        X509Certificate[] candidates = this.myTrustStore.getAACandidate(ac.getIssuer());
        if (candidates == null || candidates.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AC not valid (no such trusted issuer) : " + ac.getIssuer().getName()));
            }
            return false;
        }
        for (int i = 0; i < candidates.length; ++i) {
            if (ac.verify(candidates[i].getPublicKey())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AC signature verified OK by issuer : " + candidates[i].getSubjectX500Principal().getName()));
                }
                return true;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("AC from signature did not verify OK by issuer : " + candidates[i].getSubjectX500Principal().getName()));
        }
        return false;
    }
}

