/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust2.serialization;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.ws.sandbox.security.trust2.SecurityTokenMessage;
import org.apache.ws.sandbox.security.trust2.exception.TrustException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SecurityTokenMessageSerializer
implements Serializer {
    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (!(value instanceof SecurityTokenMessage)) {
            throw new IOException("Can't serialize a " + value.getClass().getName() + " with a SecurityTokenMessageSerializer.");
        }
        context.setPretty(false);
        SecurityTokenMessage tokenRequest = (SecurityTokenMessage)value;
        try {
            Element element = tokenRequest.getElement();
            if (name.equals(new QName(element.getNamespaceURI(), element.getLocalName()))) {
                AttributesImpl attrs = null;
                attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
                Attr ctxt = element.getAttributeNodeNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "Context");
                if (ctxt != null) {
                    attrs.addAttribute(ctxt.getNamespaceURI(), ctxt.getLocalName(), ctxt.getName(), "CDATA", ctxt.getValue());
                }
                context.startElement(name, (Attributes)attrs);
                NodeList children = element.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        context.writeDOMElement((Element)children.item(i));
                    }
                }
            } else {
                context.startElement(name, attributes);
                context.writeDOMElement(element);
            }
            context.endElement();
        }
        catch (TrustException e) {
            throw new IOException("TrustException during SecurityTokenMessage serialization: " + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Exception during SecurityTokenMessage serialization: " + e.getMessage());
        }
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }
}

