/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.local;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IReaderProxy;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import java.net.URI;

public class LocalReaderProxy
implements IReaderProxy {
    private String key = null;
    private URI locator = null;

    @Override
    public void fromLocator(URI locator) throws GRS2ProxyInvalidArgumentException, GRS2ProxyInvalidOperationException {
        if (this.locator != null) {
            throw new GRS2ProxyInvalidOperationException("Proxy already initialized with locator");
        }
        if (locator == null) {
            throw new GRS2ProxyInvalidArgumentException("Locator cannot be null");
        }
        if (!LocalReaderProxy.isOfType(locator)) {
            throw new GRS2ProxyInvalidArgumentException("Locator is not of appropriate type " + locator.toString());
        }
        String[] qs = locator.getQuery().trim().split("=");
        if (qs.length != 2) {
            throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
        }
        if (qs[1].trim().length() == 0) {
            throw new GRS2ProxyInvalidArgumentException("Invalid key in locator " + locator.toString());
        }
        this.key = qs[1];
        this.locator = locator;
    }

    @Override
    public void overrideBufferCapacity(int capacity) {
    }

    @Override
    public IBuffer getBuffer() throws GRS2ProxyInvalidOperationException {
        if (this.key == null || this.key.trim().length() == 0 || this.locator == null) {
            throw new GRS2ProxyInvalidOperationException("Proxy not correctly initialized");
        }
        return GRSRegistry.Registry.getBuffer(this.key);
    }

    public static boolean isOfType(URI locator) {
        if (!locator.getScheme().equalsIgnoreCase("grs2-proxy".toString())) {
            return false;
        }
        return locator.getFragment().equalsIgnoreCase(IProxy.ProxyType.Local.toString());
    }
}

