/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.undeployment;

import java.io.File;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.GCOREFileList;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;

public class UndeployableLibraryPackage
extends UndeployablePackage {
    private static final long serialVersionUID = 2704082975444603209L;

    public UndeployableLibraryPackage(BaseTypedPackage base) {
        super(base);
    }

    @Override
    public void packageUndeploy(Set<GCUBEScope> scopes, boolean cleanState) throws DeployException, InvalidPackageArchiveException {
        this.logger.debug((Object)("Undeploy operation called on a " + this.getType().name() + " package"));
        this.printFiles();
        for (File file : this.getPackageFileList()) {
            if (GCOREFileList.isAgCoreFile(file.getName())) {
                this.logger.warn((Object)("Cannot remove file " + file.getName() + ": this file is part of the ghn-distribution"));
                continue;
            }
            this.logger.debug((Object)("Removing file " + file.getAbsolutePath()));
            file.delete();
        }
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        for (File file : this.getPackageFileList()) {
            this.logger.trace((Object)("Verifying file " + file.getAbsolutePath()));
            if (!file.exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean requireRestart() {
        return true;
    }
}

