/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    private byte[] encodedParams;
    private byte[] encryptedContent;
    private String paramsAlg;
    private String sealAlg;

    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (cipher == null) {
            throw new IllegalArgumentException("cipher object is null!");
        }
        try {
            this.encryptedContent = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.getMessage());
        }
        this.sealAlg = cipher.getAlgorithm();
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        if (algorithmParameters != null) {
            this.encodedParams = algorithmParameters.getEncoded();
            this.paramsAlg = algorithmParameters.getAlgorithm();
        }
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new IllegalArgumentException("key object is null!");
        }
        try {
            return this.getObject(key, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.getMessage());
        }
    }

    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        if (cipher == null) {
            throw new IllegalArgumentException("cipher object is null!");
        }
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        return objectInputStream.readObject();
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (key == null) {
            throw new IllegalArgumentException("key object is null!");
        }
        Cipher cipher = null;
        try {
            cipher = string != null ? Cipher.getInstance(this.sealAlg, string) : Cipher.getInstance(this.sealAlg);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage());
        }
        if (this.paramsAlg == null) {
            cipher.init(2, key);
        } else {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.paramsAlg);
            algorithmParameters.init(this.encodedParams);
            try {
                cipher.init(2, key, algorithmParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IOException(invalidAlgorithmParameterException.getMessage());
            }
        }
        try {
            return this.getObject(cipher);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.getMessage());
        }
    }
}

