/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.trust.RequestResolver;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.trust.issue.STIssuer;
import org.apache.ws.security.trust.message.Info.RequestInfo;
import org.apache.ws.security.trust.renew.STRenewer;
import org.apache.ws.security.trust.validate.STValidator;
import org.w3c.dom.Document;

public class STSManager {
    static Log log = LogFactory.getLog((class$org$apache$ws$security$trust$STSManager == null ? (class$org$apache$ws$security$trust$STSManager = STSManager.class$("org.apache.ws.security.trust.STSManager")) : class$org$apache$ws$security$trust$STSManager).getName());
    String issuerClassName = null;
    String renewerClassName = null;
    String validatorClassName = null;
    String requestType = "";
    String tokenType = "";
    Hashtable hashOps;
    static /* synthetic */ Class class$org$apache$ws$security$trust$STSManager;

    public STSManager(Hashtable hashOps) {
        this.hashOps = hashOps;
    }

    public Document handleRequest(Document req, Document res) throws WSTrustException {
        Class<?> wClass;
        RequestResolver requestResolver = new RequestResolver(req);
        try {
            log.debug("STS Manager resolving the request");
            RequestInfo requestInfo = requestResolver.resolve();
            this.requestType = requestInfo.getRequestType();
            log.debug("STS Manager resolving completed");
        }
        catch (WSSecurityException wsEx) {
            throw new WSTrustException("STSManager: cannot resolve the request: ", wsEx);
        }
        if (this.requestType.equals("http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue")) {
            this.issuerClassName = (String)this.hashOps.get("org.apache.ws.axis.security.trust.service.SecurityTokenService.issuerClass");
            log.debug("Issuer class" + this.issuerClassName);
            wClass = null;
            try {
                wClass = Class.forName(this.issuerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new WSTrustException("STSManager: cannot load security token class: ", e);
            }
            STIssuer stissuer = null;
            try {
                stissuer = (STIssuer)wClass.newInstance();
            }
            catch (Exception e) {
                throw new WSTrustException("STSManager: cannot create instance of security token issuer: " + stissuer, e);
            }
            try {
                res = stissuer.issue(req, res);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                throw new WSTrustException("STSManager: could not issue a token " + stissuer, e);
            }
        }
        if (this.requestType.equals("http://schemas.xmlsoap.org/ws/2004/04/security/trust/Renew")) {
            this.renewerClassName = (String)this.hashOps.get("org.apache.ws.axis.security.trust.service.SecurityTokenService.renewerClass");
            log.debug("renewer  class" + this.renewerClassName);
            wClass = null;
            try {
                wClass = Class.forName(this.renewerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new WSTrustException("STSManager: cannot load security token class: ", e);
            }
            STRenewer stRenewer = null;
            try {
                stRenewer = (STRenewer)wClass.newInstance();
            }
            catch (Exception e) {
                throw new WSTrustException("STSManager: cannot create instance of security token renewer: " + stRenewer, e);
            }
            try {
                res = stRenewer.renew(req, res);
            }
            catch (Exception e) {
                throw new WSTrustException("STSManager: could not renew the token " + stRenewer, e);
            }
        }
        if (this.requestType.equals("http://schemas.xmlsoap.org/ws/2004/04/security/trust/Validate")) {
            this.validatorClassName = (String)this.hashOps.get("org.apache.ws.axis.security.trust.service.SecurityTokenService.validatorClass");
            log.debug("validatorClassName " + this.validatorClassName);
            wClass = null;
            try {
                wClass = Class.forName(this.validatorClassName);
            }
            catch (ClassNotFoundException e) {
                throw new WSTrustException("STSManager: cannot load security token class: ", e);
            }
            STValidator stValidator = null;
            try {
                stValidator = (STValidator)wClass.newInstance();
            }
            catch (Exception e) {
                throw new WSTrustException("STSManager: cannot create instance of security token validator: " + stValidator, e);
            }
            try {
                res = stValidator.validate(req, res);
            }
            catch (Exception e) {
                throw new WSTrustException("STSManager: could not validate the token " + stValidator, e);
            }
        }
        throw new WSTrustException("STSManager: Cannot Identify the Request Type ");
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

