/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Element;

public abstract class SAMLSubjectStatement
extends SAMLStatement
implements Cloneable {
    protected SAMLSubject subject = null;

    protected SAMLSubjectStatement() {
    }

    protected SAMLSubjectStatement(SAMLSubject sAMLSubject) throws SAMLException {
        this.subject = sAMLSubject;
    }

    protected SAMLSubjectStatement(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    protected SAMLSubjectStatement(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLSubjectStatement.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        this.subject = new SAMLSubject(XML.getFirstChildElement(element));
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public void setSubject(SAMLSubject sAMLSubject) throws SAMLException {
        if (sAMLSubject != null) {
            if (this.root != null) {
                this.root.replaceChild(sAMLSubject.toDOM(this.root.getOwnerDocument()), this.subject.root);
            }
        } else {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.subject = sAMLSubject;
    }

    public void checkValidity() throws SAMLException {
        if (this.subject == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SubjectStatement invalid, requires subject");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubjectStatement sAMLSubjectStatement = (SAMLSubjectStatement)super.clone();
        sAMLSubjectStatement.subject = (SAMLSubject)this.subject.clone();
        return sAMLSubjectStatement;
    }
}

