/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.ContextCredential;

public class ContextCrypto
implements Crypto {
    private static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.error", ContextCrypto.class.getClassLoader());
    private static Log log = LogFactory.getLog(ContextCrypto.class);
    private static final String ALIAS = "ContextCrypto";
    private static final String[] ALIASES = new String[]{"ContextCrypto"};
    private Properties properties;
    private CertificateFactory certFact = null;
    private static ContextCrypto crypto = new ContextCrypto();
    static String SKI_OID = "2.5.29.14";

    public static ContextCrypto getInstance() {
        return crypto;
    }

    public ContextCrypto() {
        this(null);
    }

    public ContextCrypto(Properties properties) {
        this.properties = properties == null ? System.getProperties() : properties;
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        GlobusGSSCredentialImpl cred = (GlobusGSSCredentialImpl)ContextCredential.getCurrent();
        if (cred == null) {
            return null;
        }
        return cred.getPrivateKey();
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (Exception e) {
            throw new WSSecurityException(7, "parseError");
        }
        return cert;
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        if (data == null) {
            return null;
        }
        DERObject obj = null;
        try {
            obj = BouncyCastleUtil.toDERObject(data);
        }
        catch (IOException e) {
            log.error("", e);
            throw new WSSecurityException(7, "parseError");
        }
        ASN1Sequence seq = ASN1Sequence.getInstance(obj);
        int size = seq.size();
        X509Certificate[] certs = new X509Certificate[size];
        for (int i = 0; i < size; ++i) {
            obj = seq.getObjectAt(i).getDERObject();
            try {
                data = BouncyCastleUtil.toByteArray(obj);
            }
            catch (IOException e) {
                log.error("", e);
                throw new WSSecurityException(7, "parseError");
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            try {
                certs[!reverse ? size - 1 - i : i] = CertUtil.loadCertificate(in);
                continue;
            }
            catch (GeneralSecurityException e) {
                log.error("", e);
                throw new WSSecurityException(7, "parseError");
            }
        }
        return certs;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        return ALIAS;
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        return ALIAS;
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        return ALIAS;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        return ALIAS;
    }

    public String getDefaultX509Alias() {
        return ALIAS;
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        GlobusGSSCredentialImpl cred = (GlobusGSSCredentialImpl)ContextCredential.getCurrent();
        if (cred == null) {
            return null;
        }
        return cred.getCertificateChain();
    }

    public void setKeyStore(KeyStore ks) {
    }

    public void load(InputStream input) throws CredentialException {
    }

    public KeyStore getKeyStore() {
        return null;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        return ALIASES;
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        byte[] data = null;
        if (certs == null) {
            throw new IllegalArgumentException(i18n.getMessage("certsNull"));
        }
        DEREncodableVector vec = new DEREncodableVector();
        try {
            int i;
            if (!reverse) {
                for (i = certs.length - 1; i >= 0; --i) {
                    vec.add(BouncyCastleUtil.toDERObject(certs[i].getEncoded()));
                }
            } else {
                for (i = 0; i < certs.length; ++i) {
                    vec.add(BouncyCastleUtil.toDERObject(certs[i].getEncoded()));
                }
            }
        }
        catch (CertificateEncodingException e1) {
            log.error("", e1);
            throw new WSSecurityException(7, "encodeError");
        }
        catch (IOException e2) {
            log.error("", e2);
            throw new WSSecurityException(7, "parseError");
        }
        DERSequence seq = new DERSequence(vec);
        try {
            data = BouncyCastleUtil.toByteArray(seq);
        }
        catch (IOException e) {
            log.error("", e);
            throw new WSSecurityException(7, "parseError");
        }
        return data;
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] data = null;
        byte[] abyte0 = null;
        if (cert.getVersion() < 3) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3)"});
        }
        data = cert.getExtensionValue(SKI_OID);
        if (data == null) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"No extension data"});
        }
        byte[] extensionValue = null;
        try {
            extensionValue = BouncyCastleUtil.getExtensionValue(data);
        }
        catch (IOException e1) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"cannot read SKI value as octet data"});
        }
        abyte0 = new byte[extensionValue.length - 2];
        System.arraycopy(extensionValue, 2, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public synchronized CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (this.certFact == null) {
            try {
                String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
                this.certFact = provider == null || provider.length() == 0 ? CertificateFactory.getInstance("X.509", "BC") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider");
            }
        }
        return this.certFact;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        throw new WSSecurityException(0);
    }
}

