/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.password;

import ise.antelope.tasks.password.PasswordHandlerException;
import ise.antelope.tasks.util.Base64;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class PasswordHandler {
    public static final String DESEDE = "DESede";
    public static final String DEFAULT_KEY = "The quick brown fox jumped over the lazy dog.";
    private static final String ENCODING = "UTF8";
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;

    public PasswordHandler() throws PasswordHandlerException {
        this(DEFAULT_KEY);
    }

    public PasswordHandler(String encryptKey) throws PasswordHandlerException {
        if (encryptKey == null) {
            throw new IllegalArgumentException("Encrypt key cannot be null.");
        }
        if (encryptKey.trim().length() < 32) {
            throw new IllegalArgumentException("Encrypt key cannot be less than 32 characters.");
        }
        try {
            byte[] bytes = encryptKey.getBytes(ENCODING);
            this.keySpec = new DESedeKeySpec(bytes);
            this.keyFactory = SecretKeyFactory.getInstance(DESEDE);
            this.cipher = Cipher.getInstance(DESEDE);
        }
        catch (Exception e) {
            throw new PasswordHandlerException(e);
        }
    }

    public String encrypt(String password) throws PasswordHandlerException {
        if (password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Password cannot be null or empty.");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(1, key);
            byte[] plain_bytes = password.getBytes(ENCODING);
            byte[] cipher_bytes = this.cipher.doFinal(plain_bytes);
            return Base64.encodeBytes(cipher_bytes);
        }
        catch (Exception e) {
            throw new PasswordHandlerException(e);
        }
    }

    public String decrypt(String encryptedPassword) throws PasswordHandlerException {
        if (encryptedPassword == null || encryptedPassword.trim().length() <= 0) {
            throw new IllegalArgumentException("Encrypted password cannot be null or empty.");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(2, key);
            byte[] cipher_bytes = Base64.decode(encryptedPassword);
            byte[] plain_bytes = this.cipher.doFinal(cipher_bytes);
            return new String(plain_bytes);
        }
        catch (Exception e) {
            throw new PasswordHandlerException(e);
        }
    }

    public static void main(String[] args) {
        try {
            String testPassword = "abcdef1234567890";
            System.out.println("original: " + testPassword.toString());
            System.out.println("original length: " + testPassword.length());
            PasswordHandler ph = new PasswordHandler();
            String encrypted = ph.encrypt(testPassword.toString());
            System.out.println("encrypted: " + encrypted);
            System.out.println("encrypted length: " + encrypted.length());
            if (encrypted.length() >= 32) {
                System.exit(0);
            }
            ph = new PasswordHandler();
            String plain = ph.decrypt(encrypted);
            System.out.println("decrypted: " + plain);
            if (testPassword.toString().compareTo(plain) != 0) {
                throw new Exception("test failed!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

