/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBEAuthzPolicy;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;

public interface GCUBEServiceSecurityManager
extends GCUBESecurityManager {
    public void initialise(GCUBEServiceContext var1) throws Exception;

    public void subscribe(LifetimeConsumer var1, LifetimeTopic ... var2);

    public void unsubscribe(LifetimeConsumer var1, LifetimeTopic ... var2);

    public SecurityCredentials getServiceCredentials() throws Exception;

    public SecurityCredentials getCallerCredentials() throws Exception;

    public GCUBEAuthzPolicy getPolicy();

    public boolean needServiceCredentials();

    public void propagateCallerCredentials(boolean var1);

    public static abstract class LifetimeConsumer
    implements GCUBEConsumer<LifetimeTopic, Object> {
        @Override
        public <T1 extends LifetimeTopic, P1> void onEvent(GCUBEEvent<T1, P1> ... events) {
            if (events == null || events.length == 0) {
                return;
            }
            block4: for (GCUBEEvent<T1, P1> e : events) {
                LifetimeEvent event = (LifetimeEvent)e;
                switch ((LifetimeTopic)event.getTopic()) {
                    case CREDENTIALUPDATE: {
                        this.onCredentialUpdate();
                        continue block4;
                    }
                    case POLICYUPDATE: {
                        this.onPolicyUpdate();
                    }
                }
            }
        }

        protected void onPolicyUpdate() {
        }

        protected void onCredentialUpdate() {
        }
    }

    public static class LifetimeEvent
    extends GCUBEEvent<LifetimeTopic, Object> {
    }

    public static enum LifetimeTopic implements GCUBETopic
    {
        POLICYUPDATE,
        CREDENTIALUPDATE;

    }
}

