/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.faults;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.gcube.common.core.faults.ExceptionProxy;
import org.gcube.common.core.faults.GCUBEFault;
import org.w3c.dom.Element;

public class FaultUtils {
    public static <E extends GCUBEFault> E newFault(E fault, Throwable localCause) {
        fault.setFaultMessage(localCause.getMessage());
        fault.removeFaultDetail(new QName("http://xml.apache.org/axis/", "stackTrace"));
        StringWriter w = new StringWriter();
        localCause.printStackTrace(new PrintWriter(w));
        fault.addFaultDetail(new QName("cause"), w.toString());
        try {
            fault.addFaultDetail(ExceptionProxy.newInstance(localCause).toElement());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fault;
    }

    public static Throwable remoteCause(GCUBEFault fault) {
        Serializable throwable = fault;
        for (Element d : fault.getFaultDetails()) {
            boolean match;
            String ns = d.getNamespaceURI();
            String local = d.getLocalName();
            boolean bl = match = ns != null && ns.equals("http://gcube-system.org") && local != null && local.equals("stacktrace");
            if (!match) continue;
            try {
                ExceptionProxy proxy = ExceptionProxy.newInstance(d);
                throwable = proxy.toThrowable();
            }
            catch (Throwable t) {
                throwable = new RemoteException("could not parse remote fault", t);
            }
        }
        return throwable;
    }
}

