/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.typedefs.file;

import ise.antelope.tasks.typedefs.file.FileOp;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FileList
implements FileOp {
    private String what = "files";
    private String separator = ",";
    private boolean includepath = true;

    public void setSeparator(String s) {
        if (s != null) {
            this.separator = s;
        }
    }

    public void setIncludepath(boolean b) {
        this.includepath = b;
    }

    public void setWhat(String s) {
        if (s == null || s.equals("files")) {
            this.what = "files";
            return;
        }
        if (s.equals("dirs")) {
            this.what = "dirs";
            return;
        }
        if (s.equals("all")) {
            this.what = "all";
            return;
        }
        this.what = "files";
    }

    public String execute(File f) {
        if (f == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (!f.isDirectory()) {
            return f.toString();
        }
        List<File> files = Arrays.asList(f.listFiles());
        StringBuffer value = new StringBuffer();
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            File file = it.next();
            if (!(this.what.equals("files") && file.isFile() || this.what.equals("dirs") && file.isDirectory()) && !this.what.equals("all")) continue;
            String filename = this.includepath ? file.getAbsolutePath() : file.getName();
            value.append(filename);
            if (!it.hasNext()) continue;
            value.append(this.separator);
        }
        return value.toString();
    }
}

