/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.instancestates.InstanceStatePublisher;
import org.gcube.common.informationsystem.publisher.impl.resources.RegistryResourcePublisher;

public class GCUBEPublisher
implements ISPublisher {
    protected static final GCUBELog logger = new GCUBELog(GCUBEPublisher.class);

    public InstanceStatePublisher getWSRPDocumentManager(GCUBEWSResource resource, GCUBEScope ... scope) throws GCUBEPublisherException {
        GCUBEScope myScope = scope == null || scope.length == 0 ? resource.getServiceContext().getScope() : scope[0];
        return new InstanceStatePublisher(myScope);
    }

    public void registerWSResource(GCUBEWSResource resource, GCUBEScope ... scope) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to publish a new WSResource (" + resource.getID() + ") in scope " + Arrays.toString(scope)));
        this.getWSRPDocumentManager(resource, scope).register(resource, new String[0]);
    }

    public void removeWSResource(GCUBEWSResource resource, GCUBEScope ... scope) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to remvo a WSResource (" + resource.getID() + ") from scope " + Arrays.toString(scope)));
        try {
            this.getWSRPDocumentManager(resource, scope).remove(resource, new String[0]);
        }
        catch (Exception e) {
            throw new GCUBEPublisherException("Unable to remove the resource", e);
        }
    }

    public String registerGCUBEResource(GCUBEResource profile, GCUBEScope scope, GCUBESecurityManager manager) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to publish a new GCUBEResource (" + profile.getID() + ") in scope " + scope));
        try {
            new RegistryResourcePublisher(scope).create(profile);
            logger.debug((Object)("GCUBEResource (" + profile.getID() + ") successfully published in scope " + scope));
            StringWriter writer = new StringWriter();
            profile.store((Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            logger.error((Object)("Error occurred while registering GCUBEResource " + profile.getID()));
            throw new GCUBEPublisherException("Error occurred while registering GCUBEResource", e);
        }
    }

    public void removeGCUBEResource(String ID, String type, GCUBEScope scope, GCUBESecurityManager manager) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to remove a GCUBEResource (" + ID + ") from scope " + scope));
        try {
            new RegistryResourcePublisher(scope).remove(ID, type);
            logger.debug((Object)("GCUBEResource " + ID + " successfully removed from scope " + scope));
        }
        catch (Exception e) {
            logger.error((Object)("An error occured while removing GCUBEResource " + ID));
            throw new GCUBEPublisherException("An error occured while removing GCUBEResource ", e);
        }
    }

    public void updateGCUBEResource(GCUBEResource profile, GCUBEScope scope, GCUBESecurityManager manager) throws ISPublisherException {
        try {
            new RegistryResourcePublisher(scope).update(profile);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred while updating GCUBEResource " + profile.getID()));
            throw new GCUBEPublisherException("An error occurred while updating GCUBEResource", e);
        }
    }

    public void updateWSResource(GCUBEWSResource resource, GCUBEScope ... scope) throws ISPublisherException {
        this.removeWSResource(resource, scope);
        this.registerWSResource(resource, scope);
    }
}

