/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.probes;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.gcube.common.accounting.node.persistence.RIAccountingData;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.runninginstance.ScopedAccounting;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIProfileUpdater
extends GCUBEHandler<GCUBEServiceContext> {
    private static Logger logger = LoggerFactory.getLogger(RIProfileUpdater.class);
    private HashMap<String, RIAccountingData> data = null;

    public RIProfileUpdater(HashMap<String, RIAccountingData> data) throws Exception {
        this.data = data;
        RIAccountingData tempData = data.values().iterator().next();
        logger.debug("Publishing RI profile for service " + tempData.getServiceClass() + "_" + tempData.getServiceName());
        this.setHandled(GHNContext.getContext().getServiceContext(tempData.getServiceClass(), tempData.getServiceName()));
    }

    public void run() throws Exception {
        this.updateAccoutingInfoOnProfile();
    }

    private void updateAccoutingInfoOnProfile() throws Exception {
        HashMap<GCUBEScope, ScopedAccounting> map = new HashMap<GCUBEScope, ScopedAccounting>();
        for (String scope : this.data.keySet()) {
            try {
                ScopedAccounting accounting = null;
                accounting = (ScopedAccounting)map.get(GCUBEScope.getScope((String)scope));
                if (accounting == null) {
                    accounting = new ScopedAccounting();
                    accounting.setScope(GCUBEScope.getScope((String)scope));
                }
                accounting.setTotalINCalls(Long.valueOf(this.data.get(scope).getTotalCalls()));
                accounting.getAverageCallsMap().clear();
                for (Long key : this.data.get(scope).getAvgCallsNumber().getIntervalMapping().keySet()) {
                    accounting.getAverageCallsMap().put(key, this.data.get(scope).getAvgCallsNumber().getStatistics(this.data.get(scope).getAvgCallsNumber().getIntervalMapping().get(key)));
                }
                accounting.getAverageTimeMap().clear();
                for (Long key : this.data.get(scope).getAvgInvocationTime().getIntervalMapping().keySet()) {
                    accounting.getAverageTimeMap().put(key, this.data.get(scope).getAvgInvocationTime().getStatistics(this.data.get(scope).getAvgInvocationTime().getIntervalMapping().get(key)));
                }
                String topCallerGHN = this.data.get(scope).getTopCallerData().getTopCallerInfo().getCallerHost();
                accounting.setTopCallerGHN(topCallerGHN);
                accounting.setTopCallerGHNtotalCalls(Long.valueOf(this.data.get(scope).getTopCallerData().getTopCallerInfo().getTotalCalls()));
                accounting.setTopCallerGHNavgDailyCalls(Double.valueOf(this.data.get(scope).getTopCallerData().getCallerMap().get(topCallerGHN).get(this.data.get(scope).getTopCallerData().getIntervalXday()).getAvg()));
                accounting.setTopCallerGHNavgHourlyCalls(Double.valueOf(this.data.get(scope).getTopCallerData().getCallerMap().get(topCallerGHN).get(this.data.get(scope).getTopCallerData().getIntervalXHour()).getAvg()));
                map.put(GCUBEScope.getScope((String)scope), accounting);
            }
            catch (Exception e) {
                logger.error("Error updating RI Profile", (Throwable)e);
                throw e;
            }
        }
        try {
            ((GCUBEServiceContext)this.getHandled()).getInstance().setAccounting(map);
            StringWriter writer = new StringWriter();
            ((GCUBEServiceContext)this.getHandled()).getInstance().store((Writer)writer);
            logger.debug(writer.toString());
        }
        catch (Exception e) {
            logger.error("Error updating Map on Profile", (Throwable)e);
            throw e;
        }
        ((GCUBEServiceContext)this.getHandled()).setStatus(GCUBEServiceContext.Status.UPDATED);
    }
}

