/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.encoding.ObjectDeserializationContext;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.ReflectionResource;
import org.globus.wsrf.utils.FilePersistenceHelper;
import org.globus.wsrf.utils.Resources;
import org.xml.sax.InputSource;

public class XmlPersistenceHelper
extends FilePersistenceHelper {
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    private static Log logger = LogFactory.getLog(XmlPersistenceHelper.class.getName());
    private static final String FILE_SUFFIX = ".xml";

    public XmlPersistenceHelper(Class beanClass) throws IOException {
        super(beanClass, FILE_SUFFIX);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Object key, ReflectionResource resource) throws ResourceException {
        QName resourceElementQName;
        Object loadedResourceBean;
        block8: {
            logger.debug("Loading the resource from an XML file");
            File resourceFile = this.getKeyAsFile(key);
            if (!resourceFile.exists()) {
                logger.debug(i18n.getMessage("backingFileNotFound", new Object[]{resourceFile.getPath(), key}));
                throw new NoSuchResourceException();
            }
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(resourceFile);
                    ObjectDeserializationContext deserializer = new ObjectDeserializationContext(new InputSource(in), this.beanClass);
                    deserializer.parse();
                    loadedResourceBean = deserializer.getValue();
                    resourceElementQName = deserializer.getQName();
                }
                catch (Exception e) {
                    throw new ResourceException(i18n.getMessage("resourceLoadFailed"), e);
                }
                Object var9_9 = null;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ee) {}
            in.close();
        }
        resource.initialize(loadedResourceBean, resourceElementQName, key);
    }

    public void store(ReflectionResource resource) throws ResourceException {
        this.store(resource.getID(), resource.getResourceBean(), resource.getResourcePropertySet().getName());
    }

    public void remove(ReflectionResource resource) throws ResourceException {
        Class<?> resourceBean = resource.getResourceBean().getClass();
        if (!this.beanClass.isAssignableFrom(resourceBean)) {
            Object[] args = new Object[]{this.beanClass, resourceBean};
            throw new IllegalArgumentException(i18n.getMessage("expectedType", args));
        }
        this.remove(resource.getID());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object load(Object key) throws ResourceException {
        Object loadedBean;
        logger.debug("Loading object by deserializing an XML file");
        File resourceFile = this.getKeyAsFile(key);
        if (!resourceFile.exists()) {
            logger.debug(i18n.getMessage("backingFileNotFound", new Object[]{resourceFile.getPath(), key}));
            throw new NoSuchResourceException();
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(resourceFile);
                ObjectDeserializationContext deserializer = new ObjectDeserializationContext(new InputSource(in), this.beanClass);
                deserializer.parse();
                loadedBean = deserializer.getValue();
            }
            catch (Exception e) {
                throw new ResourceException(i18n.getMessage("resourceLoadFailed"), e);
            }
            Object var7_7 = null;
            if (in == null) return loadedBean;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ee) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ee) {}
        in.close();
        return loadedBean;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(Object key, Object object, QName topElementQName) throws ResourceException {
        File file;
        File tmpFile;
        block9: {
            if (!this.beanClass.isAssignableFrom(object.getClass())) {
                Object[] args = new Object[]{this.beanClass, object == null ? null : object.getClass()};
                throw new IllegalArgumentException(i18n.getMessage("expectedType", args));
            }
            logger.debug("Storing object to an XML file");
            Writer writer = null;
            tmpFile = null;
            try {
                try {
                    tmpFile = File.createTempFile("xph", ".tmp", this.getStorageDirectory());
                    writer = new BufferedWriter(new FileWriter(tmpFile));
                    ObjectSerializer.serialize(writer, object, topElementQName);
                }
                catch (Exception e) {
                    if (tmpFile == null) throw new ResourceException(i18n.getMessage("resourceStoreFailed"), e);
                    tmpFile.delete();
                    throw new ResourceException(i18n.getMessage("resourceStoreFailed"), e);
                }
                Object var8_7 = null;
                if (writer == null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ee) {}
            writer.close();
        }
        if ((file = this.getKeyAsFile(key)).exists()) {
            file.delete();
        }
        if (tmpFile.renameTo(file)) return;
        file.delete();
        throw new ResourceException(i18n.getMessage("resourceStoreFailed"));
    }
}

