/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

public class BeanPropertySetterRule
extends Rule {
    protected String propertyName = null;
    protected String bodyText = null;

    public BeanPropertySetterRule(Digester digester, String propertyName) {
        this(propertyName);
    }

    public BeanPropertySetterRule(Digester digester) {
        this();
    }

    public BeanPropertySetterRule(String propertyName) {
        this.propertyName = propertyName;
    }

    public BeanPropertySetterRule() {
        this((String)null);
    }

    public void body(String bodyText) throws Exception {
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug((Object)("[BeanPropertySetterRule]{" + this.digester.match + "} Called with text " + bodyText));
        }
        this.bodyText = bodyText.trim();
    }

    public void end() throws Exception {
        String property = this.propertyName;
        if (property == null) {
            String match = this.digester.match;
            int slash = match.lastIndexOf(47);
            if (slash >= 0) {
                match = match.substring(slash + 1);
            }
            property = match;
        }
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug((Object)("[BeanPropertySetterRule]{" + this.digester.match + "} Setting property " + property + " with text " + this.bodyText));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(property, this.bodyText);
        Object top = this.digester.peek();
        if (top == null) {
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug((Object)("[BeanPropertySetterRule]{" + this.digester.match + "} Top object is null."));
            }
            return;
        }
        BeanUtils.populate((Object)top, map);
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BeanPropertySetterRule[");
        sb.append("propertyName=");
        sb.append(this.propertyName);
        sb.append("]");
        return sb.toString();
    }
}

