/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.gass.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gram.GramJob;
import org.globus.io.gass.client.GassException;
import org.globus.io.gass.server.GassServer;
import org.globus.io.gass.server.GassServerListener;
import org.globus.io.gass.server.JobOutputStream;
import org.globus.io.gass.server.OutputListener;
import org.globus.net.BaseServer;
import org.globus.util.GlobusURL;
import org.globus.util.deactivator.Deactivator;
import org.ietf.jgss.GSSCredential;

public class RemoteGassServer {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$io$gass$server$RemoteGassServer == null ? (class$org$globus$io$gass$server$RemoteGassServer = RemoteGassServer.class$("org.globus.io.gass.server.RemoteGassServer")) : class$org$globus$io$gass$server$RemoteGassServer).getName());
    public static final int LINE_BUFFER_ENABLE = 256;
    public static final int TILDE_EXPAND_ENABLE = 512;
    public static final int USER_EXPAND_ENABLE = 1024;
    private int port = 0;
    private int options = 0;
    private boolean secure = true;
    private GSSCredential cred = null;
    private String url = null;
    private GramJob job = null;
    private boolean compatibilityMode = false;
    private OutputListener stderrListener;
    private OutputListener stdoutListener;
    private GassServerListener gassJobListener;
    static /* synthetic */ Class class$org$globus$io$gass$server$RemoteGassServer;

    public RemoteGassServer() {
        this(true, 0);
    }

    public RemoteGassServer(boolean secure, int port) {
        this(null, secure, port);
    }

    public RemoteGassServer(GSSCredential cred, boolean secure, int port) {
        this.cred = cred;
        this.secure = secure;
        this.port = port;
        this.options = 1816;
    }

    public String getURL() {
        return this.url;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public int getOptions() {
        return this.options;
    }

    public void setCompatibilityMode(boolean compatibility) {
        this.compatibilityMode = compatibility;
    }

    public void start(String rmc) throws GassException {
        String error;
        block16: {
            if (rmc == null) {
                throw new IllegalArgumentException("Resource manager contact not specified");
            }
            BaseServer gassServer = null;
            error = null;
            try {
                gassServer = new GassServer(this.cred, 0);
                String gassURL = gassServer.getURL();
                String rsl = this.getRSL(gassURL);
                logger.debug((Object)("RSL: " + rsl));
                this.stderrListener = new OutputListener();
                this.stdoutListener = new OutputListener();
                ((GassServer)gassServer).registerJobOutputStream("err-rgs", new JobOutputStream(this.stderrListener));
                ((GassServer)gassServer).registerJobOutputStream("out-rgs", new JobOutputStream(this.stdoutListener));
                this.job = new GramJob(this.cred, rsl);
                this.gassJobListener = new GassServerListener();
                this.job.addListener(this.gassJobListener);
                this.job.request(rmc);
                int status = this.gassJobListener.waitFor(120000);
                if (status == 2) {
                    while (true) {
                        if (this.stderrListener.hasData()) {
                            error = this.stderrListener.getOutput();
                            break block16;
                        }
                        if (this.stdoutListener.hasData()) {
                            String fl = this.stdoutListener.getOutput();
                            if (fl.startsWith("https://") || fl.startsWith("http://")) {
                                this.url = fl.trim();
                            } else {
                                error = "Unable to extract gass url : " + fl;
                            }
                            break block16;
                        }
                        logger.debug((Object)"waiting for stdout/err");
                        this.sleep(500);
                    }
                }
                if (status == 4 || status == 8) {
                    int errorCode = this.gassJobListener.getError();
                    error = this.stderrListener.hasData() ? this.stderrListener.getOutput() : (errorCode != 0 ? "Remote gass server stopped with error : " + errorCode : "Remote gass server stopped and returned no error");
                } else {
                    error = "Unexpected state or received no notification";
                }
            }
            catch (Exception e) {
                throw new GassException(e.getMessage());
            }
            finally {
                if (gassServer != null) {
                    gassServer.shutdown();
                }
            }
        }
        if (error != null) {
            throw new GassException(error);
        }
    }

    public boolean shutdown() {
        if (this.url != null) {
            logger.debug((Object)"Trying to shutdown gass server directly...");
            try {
                GlobusURL u = new GlobusURL(this.url);
                GassServer.shutdown(this.cred, u);
            }
            catch (Exception e) {
                logger.debug((Object)"gass server shutdown failed", (Throwable)e);
            }
            try {
                this.gassJobListener.reset();
                int status = this.gassJobListener.waitFor(60000);
                if (status == 4 || status == 8) {
                    this.reset();
                    return true;
                }
            }
            catch (InterruptedException e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
        if (this.job == null) {
            return true;
        }
        logger.debug((Object)"Canceling gass server job.");
        try {
            this.job.cancel();
            this.reset();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void reset() {
        this.job = null;
        this.url = null;
    }

    private String getRSL(String gassURL) {
        StringBuffer buf = new StringBuffer();
        if (this.compatibilityMode) {
            buf.append("&(executable=$(GLOBUS_TOOLS_PREFIX)/bin/globus-gass-server)");
        } else {
            buf.append("&(executable=$(GLOBUS_LOCATION)/bin/globus-gass-server)");
            buf.append("(environment=(LD_LIBRARY_PATH $(GLOBUS_LOCATION)/lib))");
        }
        buf.append("(rsl_substitution=(GLOBUSRUN_GASS_URL " + gassURL + "))");
        buf.append("(stderr=$(GLOBUSRUN_GASS_URL)/dev/stderr-rgs)");
        buf.append("(stdout=$(GLOBUSRUN_GASS_URL)/dev/stdout-rgs)");
        this.setRSLArguments(buf);
        return buf.toString();
    }

    private void setRSLArguments(StringBuffer buf) {
        buf.append("(arguments=\"-c\"");
        if (this.port != 0) {
            buf.append(" \"-p\" \"" + this.port + "\"");
        }
        if (!this.secure) {
            buf.append(" \"-i\"");
        }
        if ((this.options & 0x100) != 0) {
            buf.append(" \"-l\"");
        }
        if ((this.options & 0x200) != 0) {
            buf.append(" \"-t\"");
        }
        if ((this.options & 0x400) != 0) {
            buf.append(" \"-u\"");
        }
        if ((this.options & 8) != 0) {
            buf.append(" \"-r\"");
        }
        if ((this.options & 0x10) != 0) {
            buf.append(" \"-w\"");
        }
        buf.append(")");
    }

    private void sleep(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RemoteGassServer s = null;
        int port = 0;
        boolean secure = true;
        String host = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-p")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                secure = false;
                continue;
            }
            System.err.println("Unknown command: " + args[i]);
            System.exit(1);
        }
        try {
            s = new RemoteGassServer(secure, port);
            s.setOptions(1816);
            s.start(host);
            System.out.println("Remote gass server url: " + s.getURL());
            Thread.sleep(10000L);
            System.out.println("Shutting down...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (s != null) {
                s.shutdown();
            }
        }
        System.out.println("Done");
        Deactivator.deactivateAll();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

