/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLResponse
extends SAMLSignedObject {
    protected String responseId = new SAMLIdentifier().toString();
    protected String inResponseTo = null;
    protected Date issueInstant = new Date();
    protected String recipient = null;
    protected ArrayList assertions = new ArrayList();
    protected SAMLException e = null;

    protected void insertSignature() throws SAMLException {
        this.root.insertBefore(this.getSignatureElement(), this.root.getFirstChild());
    }

    public SAMLResponse() {
    }

    public SAMLResponse(String string, String string2, Collection collection, SAMLException sAMLException) throws SAMLException {
        this.inResponseTo = string;
        this.recipient = string2;
        this.e = sAMLException;
        if (collection != null) {
            this.assertions.addAll(collection);
        }
    }

    public SAMLResponse(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLResponse(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLResponse.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        Object object2;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Response")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse.fromDOM() requires samlp:Response at root");
        }
        if (Integer.parseInt(element.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLResponse() detected incompatible response major version of " + element.getAttributeNS(null, "MajorVersion"));
        }
        this.responseId = element.getAttributeNS(null, "ResponseID");
        element.setIdAttributeNode(element.getAttributeNodeNS(null, "ResponseID"), true);
        this.inResponseTo = element.getAttributeNS(null, "InResponseTo");
        this.recipient = element.getAttributeNS(null, "Recipient");
        try {
            object2 = null;
            object = element.getAttributeNS(null, "IssueInstant");
            int n = ((String)object).indexOf(46);
            object2 = n > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("GMT"));
            this.issueInstant = ((DateFormat)object2).parse((String)object);
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse() detected an invalid datetime while parsing response", (Exception)parseException);
        }
        object2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Status");
        this.e = SAMLException.getInstance((Element)object2);
        object = this.e.getCodes();
        if (object.hasNext() && !object.next().equals(SAMLException.SUCCESS)) {
            throw this.e;
        }
        object2 = XML.getNextSiblingElement((Node)object2, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        while (object2 != null) {
            this.assertions.add(new SAMLAssertion((Element)object2));
            object2 = XML.getNextSiblingElement((Node)object2, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        }
    }

    public String getId() {
        return this.responseId;
    }

    public void setId(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.responseId = string;
        if (this.root != null) {
            this.unsign();
            ((Element)this.root).getAttributeNodeNS(null, "ResponseID").setNodeValue(string);
        }
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(String string) {
        this.inResponseTo = string;
        if (this.root != null) {
            ((Element)this.root).removeAttributeNS(null, "InResponseTo");
            if (!XML.isEmpty(string)) {
                ((Element)this.root).setAttributeNS(null, "InResponseTo", string);
            }
        }
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        if (this.root != null) {
            this.unsign();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            ((Element)this.root).getAttributeNodeNS(null, "IssueInstant").setNodeValue(simpleDateFormat.format(date));
        }
        this.issueInstant = date;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String string) {
        this.recipient = string;
        if (this.root != null) {
            ((Element)this.root).removeAttributeNS(null, "Recipient");
            if (!XML.isEmpty(string)) {
                ((Element)this.root).setAttributeNS(null, "Recipient", string);
            }
        }
    }

    public Iterator getAssertions() {
        return this.assertions.iterator();
    }

    public void setAssertions(Collection collection) throws SAMLException {
        while (this.assertions.size() > 0) {
            this.removeAssertion(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAssertion((SAMLAssertion)iterator.next());
            }
        }
    }

    public void addAssertion(SAMLAssertion sAMLAssertion) throws SAMLException {
        if (sAMLAssertion != null) {
            if (this.root != null) {
                this.unsign();
                Element element = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
                if (element == null) {
                    this.root.insertBefore(sAMLAssertion.toDOM(this.root.getOwnerDocument()), XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:protocol", "Status").getNextSibling());
                } else {
                    this.root.insertBefore(sAMLAssertion.toDOM(this.root.getOwnerDocument()), element.getNextSibling());
                }
            }
        } else {
            throw new IllegalArgumentException("assertion cannot be null");
        }
        this.assertions.add(sAMLAssertion);
    }

    public void removeAssertion(int n) throws IndexOutOfBoundsException {
        this.assertions.remove(n);
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        Object object;
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            }
            return this.root;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Response");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
        element.setAttributeNS(null, "MajorVersion", "1");
        element.setAttributeNS(null, "MinorVersion", this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? "0" : "1");
        element.setAttributeNS(null, "ResponseID", this.responseId);
        element.setIdAttributeNS(null, "ResponseID", true);
        if (!XML.isEmpty(this.inResponseTo)) {
            element.setAttributeNS(null, "InResponseTo", this.inResponseTo);
        }
        element.setAttributeNS(null, "IssueInstant", simpleDateFormat.format(this.issueInstant));
        if (!XML.isEmpty(this.recipient)) {
            element.setAttributeNS(null, "Recipient", this.recipient);
        }
        if (this.e != null) {
            element.appendChild(this.e.toDOM(document, false));
        } else {
            object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Status");
            Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
            element2.setAttributeNS(null, "Value", "samlp:" + SAMLException.SUCCESS.getLocalName());
            object.appendChild(element2);
            element.appendChild((Node)object);
        }
        object = this.assertions.iterator();
        while (object.hasNext()) {
            element.appendChild(((SAMLAssertion)object.next()).toDOM(document));
        }
        this.root = element;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLResponse sAMLResponse = (SAMLResponse)super.clone();
        if (this.e != null) {
            sAMLResponse.e = (SAMLException)this.e.clone();
        }
        Iterator iterator = this.assertions.iterator();
        while (iterator.hasNext()) {
            sAMLResponse.assertions.add(((SAMLAssertion)iterator.next()).clone());
        }
        return sAMLResponse;
    }
}

