/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.NonBlockingBufferedInputStream;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.ServiceDispatcher;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.container.ServiceRequest;
import org.globus.wsrf.container.ServiceRequestQueue;
import org.globus.wsrf.container.ServiceThreadPool;
import org.globus.wsrf.utils.PerformanceLog;
import org.globus.wsrf.utils.Resources;
import org.w3c.dom.Document;

public class ServiceThread
extends Thread {
    private static Log logger = LogFactory.getLog((String)ServiceThread.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private ServiceDispatcher dispatcher;
    private ServiceRequestQueue queue;
    private ServiceThreadPool threadPool;
    private AxisEngine engine;
    protected MessageContext msgContext;
    private NonBlockingBufferedInputStream is;
    private Message responseMsg;
    private StringBuffer soapAction;
    private StringBuffer fileName;
    private int httpRequest;
    private boolean sendContentLength = true;
    protected boolean http11;
    private boolean chunked;
    static PerformanceLog performanceLogger = new PerformanceLog(ServiceThread.class.getName() + ".performance");
    static PerformanceLog performanceProcessLogger = new PerformanceLog(ServiceThread.class.getName() + ".performance.process");
    public static final String SEND_CONTENT_LENGTH = "org.globus.wsrf.container.sendContentLength";
    protected static final byte[] HTTP_10 = "HTTP/1.0 ".getBytes();
    protected static final byte[] HTTP_11 = "HTTP/1.1 ".getBytes();
    private static final byte[] OK = "200 OK".getBytes();
    protected static final byte[] UNAUTH = "401 Unauthorized".getBytes();
    private static final byte[] ISE = "500 Internal server error".getBytes();
    private static final String FILE_NOT_FOUND = "404 ";
    private static final byte[] FILE_NOT_FOUND_MSG = "<html><body>File not found</body></html>".getBytes();
    protected static final byte[] XML_MIME_STUFF = "\r\nContent-Type: text/xml; charset=utf-8".getBytes();
    protected static final byte[] HTML_MIME_STUFF = "\r\nContent-Type: text/html; charset=utf-8".getBytes();
    protected static final byte[] JNLP_MIME_STUFF = "\r\nContent-Type: application/x-java-jnlp-file".getBytes();
    protected static final byte[] JAR_MIME_STUFF = "\r\nContent-Type: application/java-archive".getBytes();
    protected static final String CONTENT_TYPE = "\r\nContent-Type: ";
    protected static final byte[] CONTENT_LENGTH = "\r\nContent-Length: ".getBytes();
    private static final byte[] CONNECTION_CLOSE = "\r\nConnection: close".getBytes();
    private static final byte[] TRANSFER_ENCODING_CHUNKED = "\r\nTransfer-Encoding: chunked".getBytes();
    protected static final byte[] SEPARATOR = "\r\n\r\n".getBytes();
    private static final byte[] toLower = new byte[256];
    private static final byte[] LENGTH_HEADER;
    private static final byte[] ACTION_HEADER;
    private static final byte[] GET_HEADER;
    private static final byte[] HEAD_HEADER;
    private static final byte[] POST_HEADER;
    private static final byte[] HEADER_ENDER;
    private static final byte[] ENCODING_HEADER;
    private static final byte[] CHUNKED;
    private static final byte[] HTTP_BASE_VERSION;
    private static final int HTTP_GET = 1;
    private static final int HTTP_HEAD = 2;
    private static final int HTTP_POST = 3;
    private static final int BUFSIZ = 4096;
    private byte[] buf = new byte[4096];
    private boolean webStartEnabled = false;
    private String baseURL;

    public ServiceThread(ServiceDispatcher dispatcher) {
        this.setName("Service" + this.getName());
        logger.debug((Object)"Starting up thread");
        this.dispatcher = dispatcher;
        this.queue = this.dispatcher.getServiceRequestQueue();
        this.threadPool = this.dispatcher.getServiceThreadPool();
        this.engine = this.dispatcher.getAxisEngine();
        String webStart = System.getProperty("org.globus.wsrf.container.webstart");
        this.webStartEnabled = webStart != null && webStart.equalsIgnoreCase("enable");
        this.is = new NonBlockingBufferedInputStream();
        this.soapAction = new StringBuffer();
        this.fileName = new StringBuffer();
        String prop = System.getProperty(SEND_CONTENT_LENGTH);
        if (prop != null && prop.equalsIgnoreCase("false")) {
            this.sendContentLength = false;
        }
        String host = "localhost";
        try {
            host = ServiceThread.getHost(this.engine);
        }
        catch (Exception e) {
            logger.warn((Object)i18n.getMessage("noHostname"), (Throwable)e);
        }
        this.baseURL = this.getProtocol() + "://" + host + ":";
    }

    private static String getHost(AxisEngine engine) throws IOException {
        URL url = new URL("http", ServiceHost.getHost(engine), 80, "/");
        return url.getHost();
    }

    public static String getWebRootPath(AxisEngine engine) throws IOException {
        ContainerConfig config = ContainerConfig.getConfig(engine);
        String webRoot = config.getInternalWebRoot();
        if (webRoot == null) {
            webRoot = "." + File.separator;
        } else if (!webRoot.equals("") && !webRoot.endsWith(File.separator)) {
            webRoot = webRoot + File.separator;
        }
        return new File(webRoot).getCanonicalPath();
    }

    public static String getConfigRootPath(AxisEngine engine) {
        return ContainerConfig.getGlobusLocation();
    }

    private void reset() {
        Service.clearCall();
        if (this.msgContext != null) {
            this.msgContext.reset();
            this.msgContext.dispose();
        }
        this.msgContext = this.dispatcher.createMessageContext();
        this.responseMsg = null;
    }

    private void handleOutOfMemoryError() {
        this.reset();
        System.runFinalization();
        System.gc();
    }

    public void run() {
        while (true) {
            this.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Thread " + this.getName() + " listening for requests"));
            }
            try {
                ServiceRequest request = this.queue.dequeue();
                if (request == null) {
                    logger.debug((Object)("Stopping thread " + this.getName()));
                    this.threadPool.removeThread(this);
                    break;
                }
                performanceProcessLogger.start();
                this.process(request);
                performanceProcessLogger.stop("process");
            }
            catch (OutOfMemoryError e) {
                logger.error((Object)i18n.getMessage("memFault01"), (Throwable)e);
                this.handleOutOfMemoryError();
            }
            catch (Throwable e) {
                logger.error((Object)i18n.getMessage("serverFault02"), e);
            }
        }
    }

    protected String getProtocol() {
        return "http";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(ServiceRequest request) {
        socket = request.getSocket();
        out = null;
        in = null;
        if (ServiceThread.logger.isDebugEnabled()) {
            ServiceThread.logger.debug((Object)("Thread " + this.getName() + " processing requests"));
        }
        try {
            block79: {
                block78: {
                    out = socket.getOutputStream();
                    in = socket.getInputStream();
                    status = ServiceThread.OK;
                    doWsdl = false;
                    filePart = "";
                    this.is.setInputStream(in);
                    try {
                        contentLength = this.parseHeaders((InputStream)this.is, this.soapAction, this.fileName);
                        if (contentLength >= 0) {
                            this.is.setContentLength(contentLength);
                        }
                        if ((paramIdx = this.fileName.toString().indexOf(63)) != -1) {
                            params = this.fileName.substring(paramIdx + 1);
                            this.fileName.setLength(paramIdx);
                            if (ServiceThread.logger.isDebugEnabled()) {
                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("filename00", (Object)this.fileName.toString()));
                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("params00", (Object)params));
                            }
                            if ("wsdl".equalsIgnoreCase(params)) {
                                doWsdl = true;
                            }
                        }
                        filePart = this.fileName.toString();
                        this.msgContext.setProperty("realpath", (Object)filePart);
                        this.msgContext.setProperty("remoteaddr", (Object)socket.getInetAddress().getHostAddress());
                        serverSocket = request.getServerSocket();
                        url = this.baseURL + serverSocket.getLocalPort() + "/" + filePart;
                        this.msgContext.setProperty("transport.url", (Object)url);
                        if (this.httpRequest == 1) {
                            if (doWsdl) {
                                this.doWSDL(this.engine, this.msgContext, out, filePart);
                                break block78;
                            } else {
                                this.doGet(this.engine, this.msgContext, out, filePart, true);
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception e) {
                        status = this.doFault(e, this.msgContext, filePart);
                        break block79;
                    }
                }
                var13_17 = null;
                ** GOTO lbl189
lbl-1000:
                // 1 sources

                {
                    if (this.httpRequest != 2) ** GOTO lbl-1000
                    this.doGet(this.engine, this.msgContext, out, filePart, false);
                }
                ** GOTO lbl217
lbl-1000:
                // 1 sources

                {
                    this.doPost(this.engine, this.msgContext);
                }
            }
            if (this.responseMsg == null) {
                out.write(this.createHeaderReply(ServiceThread.OK, ServiceThread.XML_MIME_STUFF, 0L));
            } else {
                contentType = "\r\nContent-Type: " + this.responseMsg.getContentType(this.msgContext.getSOAPConstants());
                if (this.chunked) {
                    out.write(this.createHeaderReply(status, contentType.getBytes(), -1L));
                    out = new ChunkedOutputStream(out);
                } else {
                    out.write(this.createHeaderReply(status, contentType.getBytes(), this.responseMsg.getContentLength()));
                }
                this.responseMsg.writeTo(out);
            }
            out.flush();
            ** GOTO lbl246
        }
        catch (InterruptedIOException iie) {
            var13_20 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
            }
            try {
                if (socket == null) return;
                socket.close();
                return;
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
            }
            return;
        }
        catch (SocketException se) {
            block85: {
                block84: {
                    block83: {
                        ServiceThread.logger.debug((Object)"Socket exception", (Throwable)se);
                        var13_21 = null;
                        ** try [egrp 5[TRYBLOCK] [19 : 625->636)] { 
lbl99:
                        // 1 sources

                        if (out != null) {
                            out.close();
                        }
                        break block83;
lbl102:
                        // 1 sources

                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [20 : 656->669)] { 
lbl106:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    break block84;
lbl109:
                    // 1 sources

                    catch (Exception e) {
                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                    }
                }
                ** try [egrp 7[TRYBLOCK] [21 : 689->706)] { 
lbl113:
                // 1 sources

                if (this.is != null) {
                    this.is.close();
                }
                break block85;
lbl116:
                // 1 sources

                catch (Exception e) {
                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                }
            }
            try {}
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                return;
            }
            if (socket == null) return;
            socket.close();
            return;
        }
        catch (Exception e) {
            block88: {
                block87: {
                    block86: {
                        ServiceThread.logger.error((Object)ServiceThread.i18n.getMessage("general"), (Throwable)e);
                        var13_22 = null;
                        ** try [egrp 5[TRYBLOCK] [19 : 625->636)] { 
lbl131:
                        // 1 sources

                        if (out != null) {
                            out.close();
                        }
                        break block86;
lbl134:
                        // 1 sources

                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [20 : 656->669)] { 
lbl138:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    break block87;
lbl141:
                    // 1 sources

                    catch (Exception e) {
                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                    }
                }
                ** try [egrp 7[TRYBLOCK] [21 : 689->706)] { 
lbl145:
                // 1 sources

                if (this.is != null) {
                    this.is.close();
                }
                break block88;
lbl148:
                // 1 sources

                catch (Exception e) {
                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                }
            }
            try {}
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                return;
            }
            if (socket == null) return;
            socket.close();
            return;
        }
        {
            block100: {
                block99: {
                    block98: {
                        block97: {
                            block96: {
                                block95: {
                                    block94: {
                                        block93: {
                                            block92: {
                                                catch (Throwable var12_31) {
                                                    block91: {
                                                        block90: {
                                                            block89: {
                                                                var13_23 = null;
                                                                ** try [egrp 5[TRYBLOCK] [19 : 625->636)] { 
lbl162:
                                                                // 1 sources

                                                                if (out != null) {
                                                                    out.close();
                                                                }
                                                                break block89;
lbl165:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                                                                }
                                                            }
                                                            ** try [egrp 6[TRYBLOCK] [20 : 656->669)] { 
lbl169:
                                                            // 1 sources

                                                            if (in != null) {
                                                                in.close();
                                                            }
                                                            break block90;
lbl172:
                                                            // 1 sources

                                                            catch (Exception e) {
                                                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                                            }
                                                        }
                                                        ** try [egrp 7[TRYBLOCK] [21 : 689->706)] { 
lbl176:
                                                        // 1 sources

                                                        if (this.is != null) {
                                                            this.is.close();
                                                        }
                                                        break block91;
lbl179:
                                                        // 1 sources

                                                        catch (Exception e) {
                                                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                                        }
                                                    }
                                                    ** try [egrp 8[TRYBLOCK] [22 : 726->737)] { 
lbl183:
                                                    // 1 sources

                                                    if (socket == null) throw var12_31;
                                                    socket.close();
                                                    throw var12_31;
lbl186:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                                                    }
                                                    throw var12_31;
                                                }
lbl189:
                                                // 1 sources

                                                ** try [egrp 5[TRYBLOCK] [19 : 625->636)] { 
lbl190:
                                                // 1 sources

                                                if (out != null) {
                                                    out.close();
                                                }
                                                break block92;
lbl193:
                                                // 1 sources

                                                catch (Exception e) {
                                                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                                                }
                                            }
                                            ** try [egrp 6[TRYBLOCK] [20 : 656->669)] { 
lbl197:
                                            // 1 sources

                                            if (in != null) {
                                                in.close();
                                            }
                                            break block93;
lbl200:
                                            // 1 sources

                                            catch (Exception e) {
                                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                            }
                                        }
                                        ** try [egrp 7[TRYBLOCK] [21 : 689->706)] { 
lbl204:
                                        // 1 sources

                                        if (this.is != null) {
                                            this.is.close();
                                        }
                                        break block94;
lbl207:
                                        // 1 sources

                                        catch (Exception e) {
                                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                        }
                                    }
                                    try {}
                                    catch (Exception e) {
                                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                                        return;
                                    }
                                    if (socket == null) return;
                                    socket.close();
                                    return;
lbl217:
                                    // 1 sources

                                    var13_18 = null;
                                    ** try [egrp 5[TRYBLOCK] [19 : 625->636)] { 
lbl219:
                                    // 1 sources

                                    if (out != null) {
                                        out.close();
                                    }
                                    break block95;
lbl222:
                                    // 1 sources

                                    catch (Exception e) {
                                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                                    }
                                }
                                ** try [egrp 6[TRYBLOCK] [20 : 656->669)] { 
lbl226:
                                // 1 sources

                                if (in != null) {
                                    in.close();
                                }
                                break block96;
lbl229:
                                // 1 sources

                                catch (Exception e) {
                                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                }
                            }
                            ** try [egrp 7[TRYBLOCK] [21 : 689->706)] { 
lbl233:
                            // 1 sources

                            if (this.is != null) {
                                this.is.close();
                            }
                            break block97;
lbl236:
                            // 1 sources

                            catch (Exception e) {
                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                            }
                        }
                        try {}
                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                            return;
                        }
                        if (socket == null) return;
                        socket.close();
                        return;
lbl246:
                        // 1 sources

                        var13_19 = null;
                        ** try [egrp 5[TRYBLOCK] [19 : 625->636)] { 
lbl248:
                        // 1 sources

                        if (out != null) {
                            out.close();
                        }
                        break block98;
lbl251:
                        // 1 sources

                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [20 : 656->669)] { 
lbl255:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    break block99;
lbl258:
                    // 1 sources

                    catch (Exception e) {
                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                    }
                }
                ** try [egrp 7[TRYBLOCK] [21 : 689->706)] { 
lbl262:
                // 1 sources

                if (this.is != null) {
                    this.is.close();
                }
                break block100;
lbl265:
                // 1 sources

                catch (Exception e) {
                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                }
            }
            try {}
            catch (Exception e) {}
            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
            return;
            if (socket == null) return;
            socket.close();
            return;
        }
    }

    private byte[] createHeaderReply(byte[] code, byte[] contentType, long length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.http11 ? HTTP_11 : HTTP_10);
        out.write(code);
        if (contentType != null) {
            out.write(contentType);
        }
        if (length < 0L) {
            out.write(TRANSFER_ENCODING_CHUNKED);
        } else if (this.sendContentLength) {
            out.write(CONTENT_LENGTH);
            out.write(String.valueOf(length).getBytes());
        }
        if (this.http11) {
            out.write(CONNECTION_CLOSE);
        }
        out.write(SEPARATOR);
        return out.toByteArray();
    }

    protected void doWSDL(AxisEngine engine, MessageContext msgContext, OutputStream out, String filePart) throws IOException {
        try {
            engine.generateWSDL(msgContext);
        }
        catch (Exception e) {
            AxisFault fault;
            byte[] status = ISE;
            byte[] contentType = HTML_MIME_STUFF;
            byte[] msg = null;
            if (e instanceof AxisFault && (fault = (AxisFault)((Object)e)).getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                status = (FILE_NOT_FOUND + filePart).getBytes();
                msg = FILE_NOT_FOUND_MSG;
            }
            if (msg == null) {
                logger.debug((Object)"Get wsdl error", (Throwable)e);
                StringWriter sWriter = new StringWriter();
                PrintWriter pWriter = new PrintWriter(sWriter);
                pWriter.println("<html><body>");
                pWriter.println("<h2>Error getting wsdl:</h2><pre>");
                e.printStackTrace(pWriter);
                pWriter.println("</pre></body></html>");
                pWriter.flush();
                String encoding = XMLUtils.getEncoding((MessageContext)msgContext);
                contentType = ("\r\nContent-Type: text/html; charset=" + encoding.toLowerCase()).getBytes();
                msg = sWriter.toString().getBytes(encoding);
            }
            out.write(this.createHeaderReply(status, contentType, msg.length));
            out.write(msg);
            out.flush();
            return;
        }
        Document doc = (Document)msgContext.getProperty("WSDL");
        if (doc != null) {
            String encoding = XMLUtils.getEncoding((MessageContext)msgContext);
            String contentType = "\r\nContent-Type: text/xml; charset=" + encoding.toLowerCase();
            String response = XMLUtils.DocumentToString((Document)doc);
            byte[] respBytes = response.getBytes(encoding);
            out.write(this.createHeaderReply(OK, contentType.getBytes(), respBytes.length));
            out.write(respBytes);
            out.flush();
        }
    }

    protected void doGet(AxisEngine engine, MessageContext msgContext, OutputStream out, String filePart, boolean returnContent) {
        try {
            this.doGetSub(engine, msgContext, out, filePart, returnContent);
        }
        catch (FileNotFoundException e) {
            try {
                byte[] status = (FILE_NOT_FOUND + filePart).getBytes();
                out.write(this.createHeaderReply(status, HTML_MIME_STUFF, FILE_NOT_FOUND_MSG.length));
                out.write(FILE_NOT_FOUND_MSG);
                out.flush();
            }
            catch (IOException ee) {
                logger.debug((Object)i18n.getMessage("errorWritingResponse"), (Throwable)e);
            }
        }
        catch (SocketException e) {
        }
        catch (IOException e) {
            try {
                out.write(this.createHeaderReply(ISE, HTML_MIME_STUFF, 0L));
                out.flush();
            }
            catch (IOException ee) {
                logger.debug((Object)i18n.getMessage("errorWritingResponse"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGetSub(AxisEngine engine, MessageContext msgContext, OutputStream out, String filePart, boolean returnContent) throws IOException {
        FileInputStream getFileStream;
        block14: {
            block13: {
                String webRootPath = (String)msgContext.getProperty("home.dir");
                File getFile = new File(webRootPath, filePart);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to retrieve file from:" + getFile));
                }
                if (!getFile.getCanonicalPath().startsWith(webRootPath)) {
                    throw new FileNotFoundException(filePart);
                }
                boolean xmlContent = filePart.endsWith(".xsd") || filePart.endsWith(".wsdl") || filePart.endsWith(".gwsdl");
                boolean jnlpContent = filePart.endsWith(".jnlp");
                boolean jarContent = filePart.endsWith(".jar");
                if (!xmlContent && !jnlpContent) {
                    if (!jarContent) throw new FileNotFoundException(filePart);
                }
                if ((jnlpContent || jarContent) && !this.webStartEnabled) {
                    throw new FileNotFoundException(filePart);
                }
                getFileStream = new FileInputStream(getFile);
                try {
                    int bytesRead;
                    byte[] type = null;
                    if (xmlContent) {
                        type = XML_MIME_STUFF;
                    } else if (jnlpContent) {
                        type = JNLP_MIME_STUFF;
                    } else if (jarContent) {
                        type = JAR_MIME_STUFF;
                    }
                    out.write(this.createHeaderReply(OK, type, getFile.length()));
                    if (!returnContent) {
                        Object var16_13 = null;
                        break block13;
                    }
                    byte[] fileBuffer = new byte[4096];
                    while ((bytesRead = getFileStream.read(fileBuffer, 0, 4096)) > 0) {
                        out.write(fileBuffer, 0, bytesRead);
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var16_15 = null;
                    getFileStream.close();
                    throw throwable;
                }
            }
            getFileStream.close();
            return;
        }
        Object var16_14 = null;
        getFileStream.close();
    }

    protected void doPost(AxisEngine engine, MessageContext msgContext) throws AxisFault {
        String soapActionString = this.soapAction.toString();
        if (soapActionString != null) {
            msgContext.setUseSOAPAction(true);
            msgContext.setSOAPActionURI(soapActionString);
        }
        NonBlockingBufferedInputStream in = this.is;
        if (this.chunked) {
            in = new ChunkedInputStream((InputStream)this.is);
        }
        Message requestMsg = new Message((Object)in);
        msgContext.setRequestMessage(requestMsg);
        performanceLogger.start();
        engine.invoke(msgContext);
        performanceLogger.stop("Post: Engine Invoke");
        this.responseMsg = msgContext.getResponseMessage();
    }

    protected byte[] doFault(Exception e, MessageContext msgContext, String filepart) {
        AxisFault af;
        byte[] status = OK;
        if (e instanceof AxisFault) {
            af = (AxisFault)((Object)e);
            if (((Object)((Object)af)).getClass().equals(AxisFault.class) && af.detail instanceof InvocationTargetException) {
                Throwable rootException = ((InvocationTargetException)af.detail).getTargetException();
                if (rootException instanceof OutOfMemoryError) {
                    logger.error((Object)i18n.getMessage("memFault02"), rootException);
                    this.handleOutOfMemoryError();
                } else {
                    logger.debug((Object)i18n.getMessage("serverFault00"), rootException);
                }
                af = new AxisFault(i18n.getMessage("serverFault00"), rootException);
            } else {
                logger.debug((Object)i18n.getMessage("serverFault00"), (Throwable)af);
            }
            QName faultCode = af.getFaultCode();
            status = faultCode != null && "Server.Unauthorized".equals(faultCode.getLocalPart()) ? UNAUTH : ISE;
        } else {
            status = e instanceof IOException ? (FILE_NOT_FOUND + filepart).getBytes() : ISE;
            af = AxisFault.makeFault((Exception)e);
        }
        this.responseMsg = msgContext.getResponseMessage();
        if (this.responseMsg == null) {
            this.responseMsg = new Message((Object)af);
        } else {
            try {
                SOAPEnvelope env = this.responseMsg.getSOAPEnvelope();
                env.clearBody();
                env.addBodyElement((SOAPBodyElement)new SOAPFault(af));
            }
            catch (AxisFault fault) {
                logger.error((Object)i18n.getMessage("unexpectedError"), (Throwable)e);
            }
        }
        return status;
    }

    private int readLine(InputStream is, byte[] b, int off, int len) throws IOException {
        int c;
        int count = 0;
        while ((c = is.read()) != -1) {
            b[off++] = (byte)c;
            if (c != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseRequest(StringBuffer fileName, byte[] buf, int n, int offset) throws IOException {
        char c;
        int i;
        fileName.delete(0, fileName.length());
        for (i = 0; i < n - offset && (c = (char)(buf[i + offset] & 0x7F)) != ' '; ++i) {
            fileName.append(c);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)i18n.getMessage("filename01", (Object[])new String[]{"ServiceThread", fileName.toString()}));
        }
        if (!this.matches(buf, i + offset + 1, HTTP_BASE_VERSION)) throw new IOException(i18n.getMessage("malformedHTTPVersion"));
        int j = i + offset + 1 + HTTP_BASE_VERSION.length;
        if (j + 3 > n) {
            throw new IOException(i18n.getMessage("malformedHTTPVersion"));
        }
        if (buf[j] != 49) {
            throw new IOException(i18n.getMessage("unsupportedHTTPMajor"));
        }
        if (buf[j + 2] == 48) {
            this.http11 = false;
            return;
        } else {
            if (buf[j + 2] != 49) throw new IOException(i18n.getMessage("unsupportedHTTMinor"));
            this.http11 = true;
        }
    }

    private int parseHeaders(InputStream is, StringBuffer soapAction, StringBuffer fileName) throws IOException {
        int n = this.readLine(is, this.buf, 0, this.buf.length);
        if (n < 0) {
            throw new IOException(i18n.getMessage("unexpectedEOS00"));
        }
        soapAction.delete(0, soapAction.length());
        this.httpRequest = -1;
        this.chunked = false;
        if (this.buf[0] == GET_HEADER[0]) {
            this.httpRequest = 1;
            this.parseRequest(fileName, this.buf, n, 5);
            return 0;
        }
        if (this.buf[0] == HEAD_HEADER[0]) {
            this.httpRequest = 2;
            this.parseRequest(fileName, this.buf, n, 5);
            return 0;
        }
        if (this.buf[0] != POST_HEADER[0]) {
            throw new IOException(i18n.getMessage("badRequest00"));
        }
        this.httpRequest = 3;
        this.parseRequest(fileName, this.buf, n, 6);
        int len = -1;
        while ((n = this.readLine(is, this.buf, 0, this.buf.length)) > 0 && (n > 2 || this.buf[0] != 10 && this.buf[0] != 13)) {
            int endHeaderIndex;
            for (endHeaderIndex = 0; endHeaderIndex < n && toLower[this.buf[endHeaderIndex]] != HEADER_ENDER[0]; ++endHeaderIndex) {
            }
            int i = (endHeaderIndex += 2) - 1;
            if (endHeaderIndex == LENGTH_HEADER.length && this.matches(this.buf, LENGTH_HEADER)) {
                len = 0;
                while (++i < n && this.buf[i] >= 48 && this.buf[i] <= 57) {
                    len = len * 10 + (this.buf[i] - 48);
                }
                continue;
            }
            if (endHeaderIndex == ACTION_HEADER.length && this.matches(this.buf, ACTION_HEADER)) {
                ++i;
                while (++i < n && this.buf[i] != 34) {
                    soapAction.append((char)(this.buf[i] & 0x7F));
                }
                continue;
            }
            if (endHeaderIndex != ENCODING_HEADER.length || !this.matches(this.buf, ENCODING_HEADER)) continue;
            this.chunked = this.matches(this.buf, i + 1, CHUNKED) && this.http11;
        }
        return len;
    }

    public boolean matches(byte[] buf, byte[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (toLower[buf[i]] == target[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matches(byte[] buf, int bufIdx, byte[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (toLower[buf[bufIdx + i]] == target[i]) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ServiceThread.toLower[i] = (byte)i;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            ServiceThread.toLower[lc + 65 - 97] = (byte)lc;
        }
        LENGTH_HEADER = "content-length: ".getBytes();
        ACTION_HEADER = "soapaction: ".getBytes();
        GET_HEADER = "GET".getBytes();
        HEAD_HEADER = "HEAD".getBytes();
        POST_HEADER = "POST".getBytes();
        HEADER_ENDER = ": ".getBytes();
        ENCODING_HEADER = "transfer-encoding: ".getBytes();
        CHUNKED = "chunked".getBytes();
        HTTP_BASE_VERSION = "http/".getBytes();
    }
}

