/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.cs;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.gcube.common.core.resources.GCUBECS;
import org.gcube.common.resources.kxml.GCUBEResourceImpl;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.utils.KAny;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KGCUBECS
extends GCUBECS
implements GCUBEResourceImpl {
    static final SimpleDateFormat dateAndTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public synchronized void load(Reader reader) throws Exception {
        KGCUBEResource.load(this, reader);
    }

    @Override
    public synchronized void store(Writer writer) throws Exception {
        KGCUBEResource.store(this, writer);
    }

    @Override
    public InputStream getSchemaResource() throws FileNotFoundException {
        return KGCUBECS.class.getResourceAsStream("/org/gcube/common/resources/kxml/schemas/cs.xsd");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void load(KXmlParser parser) throws Exception {
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Base64")) {
                        this.setBase64(Boolean.parseBoolean(parser.nextText()));
                    }
                    if (parser.getName().equals("Description")) {
                        this.setDescription(parser.nextText());
                    }
                    if (parser.getName().equals("WSDL")) {
                        this.setWSDL(KAny.load("WSDL", parser));
                    }
                    if (parser.getName().equals("BPEL")) {
                        this.setBPEL(KAny.load("BPEL", parser));
                    }
                    if (parser.getName().equals("Osiris")) {
                        this.setOsiris(KAny.load("Osiris", parser));
                    }
                    if (parser.getName().equals("Creator")) {
                        this.setCreator(parser.nextText());
                    }
                    if (parser.getName().equals("CreationTime")) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(dateAndTime.parse(parser.nextText()));
                        this.setCreationTime(cal);
                    }
                    if (!parser.getName().equals("ProcessName")) break;
                    this.setProcessName(parser.nextText());
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Profile")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at Profile");
                }
            }
        }
    }

    @Override
    public void store(KXmlSerializer serializer) throws Exception {
        serializer.startTag(KGCUBEResource.NS, "Profile");
        serializer.startTag(KGCUBEResource.NS, "Base64").text(Boolean.toString(this.isBase64())).endTag(KGCUBEResource.NS, "Base64");
        if (this.getDescription() != null) {
            serializer.startTag(KGCUBEResource.NS, "Description").text(this.getDescription()).endTag(KGCUBEResource.NS, "Description");
        }
        if (this.getWSDL() != null) {
            KAny.store("WSDL", this.getWSDL(), serializer);
        }
        if (this.getBPEL() != null) {
            KAny.store("BPEL", this.getBPEL(), serializer);
        }
        if (this.getOsiris() != null) {
            KAny.store("Osiris", this.getOsiris(), serializer);
        }
        if (this.getCreator() != null) {
            serializer.startTag(KGCUBEResource.NS, "Creator").text(this.getCreator()).endTag(KGCUBEResource.NS, "Creator");
        }
        if (this.getCreationTime() != null) {
            serializer.startTag(KGCUBEResource.NS, "CreationTime").text(dateAndTime.format(this.getCreationTime().getTime())).endTag(KGCUBEResource.NS, "CreationTime");
        }
        if (this.getProcessName() != null) {
            serializer.startTag(KGCUBEResource.NS, "ProcessName").text(this.getProcessName()).endTag(KGCUBEResource.NS, "ProcessName");
        }
        serializer.endTag(KGCUBEResource.NS, "Profile");
    }
}

