/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.state;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gcube.common.core.utils.logging.GCUBELog;

public class GCUBEReadWriteLock
extends ReentrantReadWriteLock {
    protected GCUBELog logger = new GCUBELog(GCUBEReadWriteLock.class);
    private static final long serialVersionUID = 1L;
    private GCUBEWriteLock writeLock = new GCUBEWriteLock(this);
    private GCUBEReadLock readLock = new GCUBEReadLock(this);
    protected volatile Thread preemptingThread;
    protected volatile boolean preempted;

    public GCUBEReadWriteLock() {
    }

    public GCUBEReadWriteLock(boolean fair) {
        super(fair);
    }

    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    @Override
    public GCUBEWriteLock writeLock() {
        return this.writeLock;
    }

    @Override
    public GCUBEReadLock readLock() {
        return this.readLock;
    }

    protected boolean isPreempted() {
        return this.preempted;
    }

    static class LockPreemptedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        LockPreemptedException() {
        }
    }

    public static class GCUBEWriteLock
    extends ReentrantReadWriteLock.WriteLock {
        private static final long serialVersionUID = 1L;
        GCUBEReadWriteLock parent;

        GCUBEWriteLock(GCUBEReadWriteLock rwLock) {
            super(rwLock);
            this.parent = rwLock;
        }

        @Override
        public void lock() throws LockPreemptedException {
            try {
                this.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new LockPreemptedException();
            }
        }

        @Override
        public boolean tryLock() {
            if (this.parent.isPreempted()) {
                return false;
            }
            return super.tryLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (this.parent.isPreempted()) {
                throw new InterruptedException();
            }
            super.lockInterruptibly();
            this.parent.logger.trace(Thread.currentThread().getName() + " locked");
        }

        public void lockPreemptively() throws InterruptedException {
            if (this.parent.isPreempted()) {
                throw new InterruptedException();
            }
            this.lockInterruptibly();
            this.parent.preemptingThread = Thread.currentThread();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (this.parent.isPreempted()) {
                throw new InterruptedException();
            }
            return super.tryLock(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            this.parent.logger.trace(Thread.currentThread().getName() + " unlocked");
            if (Thread.currentThread() == this.parent.preemptingThread) {
                this.parent.preempted = true;
                Lock lock = this;
                synchronized (lock) {
                    for (Thread waitingThread : this.parent.getQueuedWriterThreads()) {
                        if (waitingThread == this.parent.preemptingThread) continue;
                        waitingThread.interrupt();
                    }
                }
                lock = this.parent.readLock;
                synchronized (lock) {
                    for (Thread waitingThread : this.parent.getQueuedReaderThreads()) {
                        waitingThread.interrupt();
                    }
                }
            }
            super.unlock();
        }

        public void cancelPreemptive() throws IllegalMonitorStateException {
            if (Thread.currentThread() != this.parent.preemptingThread) {
                throw new IllegalMonitorStateException();
            }
            this.parent.preemptingThread = null;
            this.parent.preempted = false;
        }
    }

    public static class GCUBEReadLock
    extends ReentrantReadWriteLock.ReadLock {
        private static final long serialVersionUID = 1L;
        GCUBEReadWriteLock parent;

        GCUBEReadLock(GCUBEReadWriteLock rwLock) {
            super(rwLock);
            this.parent = rwLock;
        }

        @Override
        public void lock() throws LockPreemptedException {
            try {
                this.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new LockPreemptedException();
            }
        }

        @Override
        public boolean tryLock() {
            if (this.parent.isPreempted()) {
                return false;
            }
            return super.tryLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (this.parent.isPreempted()) {
                throw new InterruptedException();
            }
            this.parent.logger.trace(Thread.currentThread().getName() + " locked");
            super.lockInterruptibly();
        }
    }
}

