/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.gsi;

import java.util.Hashtable;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;

public class NetscapeTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String host = null;
        String binddn = null;
        String baseDN = "mds-vo-name=local, o=grid";
        String filter = "(objectclass=*)";
        String qop = "auth-conf, auth";
        boolean debug = false;
        int port = 389;
        int version = 3;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-p")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-ver")) {
                version = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-d")) {
                debug = true;
                continue;
            }
            if (args[i].equals("-D")) {
                binddn = args[++i];
                continue;
            }
            if (args[i].equals("-b")) {
                baseDN = args[++i];
                continue;
            }
            if (args[i].equals("-qop")) {
                qop = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-usage") || args[i].equalsIgnoreCase("-help")) {
                System.err.println("Usage: NetscapeTest -h [host] -p [port] -D [binddn] [-d] -b [baseDN]");
                System.err.println("\tExample: NetscapeTest -h mds.globus.org -p 389 -r o=globus,c=us");
                System.exit(1);
                continue;
            }
            System.err.println("Invalid argument: " + args[i]);
            System.exit(1);
        }
        if (host == null) {
            System.err.println("Error: hostname not specified!");
            System.exit(1);
        }
        LDAPConnection ld = null;
        ld = new LDAPConnection();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("javax.security.sasl.client.pkgs", "org.globus.mds.gsi.netscape");
        props.put("javax.security.sasl.qop", qop);
        try {
            if (debug) {
                ld.setProperty("debug", (Object)"true");
                ld.setProperty("com.netscape.ldap.trace", (Object)System.out);
            }
            ld.setOption(17, (Object)new Integer(version));
            ld.connect(host, port);
            ld.authenticate(binddn, new String[]{"GSS-OWNYQ6NTEOAUVGWG"}, props, null);
            LDAPSearchResults myResults = null;
            myResults = ld.search(baseDN, 1, filter, null, false);
            while (myResults.hasMoreElements()) {
                LDAPEntry myEntry = myResults.next();
                String nextDN = myEntry.getDN();
                System.out.println(nextDN + ":");
                LDAPAttributeSet entryAttrs = myEntry.getAttributeSet();
                System.out.println(entryAttrs);
                System.out.println();
            }
        }
        catch (Exception e) {
            System.err.println("NetscapeTest failed: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                ld.disconnect();
            }
            catch (Exception ee) {}
        }
    }
}

