/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.topicexpression.InvalidTopicExpressionException;
import org.globus.wsrf.topicexpression.TopicExpressionEngine;
import org.globus.wsrf.topicexpression.TopicExpressionEvaluator;
import org.globus.wsrf.topicexpression.TopicExpressionException;
import org.globus.wsrf.topicexpression.TopicExpressionResolutionException;
import org.globus.wsrf.topicexpression.UnsupportedTopicExpressionDialectException;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.TopicExpressionType;

public class TopicExpressionEngineImpl
implements TopicExpressionEngine {
    private static String TOPIC_EXPRESSION_EVALUATOR_CONTEXT = "java:comp/env//topic/eval";
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    static Log logger = LogFactory.getLog(TopicExpressionEngineImpl.class.getName());
    private Map evaluators = new HashMap();
    static /* synthetic */ Class class$org$globus$wsrf$topicexpression$TopicExpressionEvaluator;

    public TopicExpressionEngineImpl() {
        this.refresh();
    }

    public static TopicExpressionEngine getInstance() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            return (TopicExpressionEngine)context.lookup("java:comp/env//topic/ContainerTopicExpressionEngine");
        }
        catch (NamingException e) {
            logger.error(i18n.getMessage("topicEngineConfigError"), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        this.evaluators.clear();
        NamingEnumeration<NameClassPair> list = null;
        try {
            InitialContext context = new InitialContext();
            list = context.list(TOPIC_EXPRESSION_EVALUATOR_CONTEXT);
            NameClassPair pair = null;
            TopicExpressionEvaluator evaluator = null;
            while (list.hasMore()) {
                pair = list.next();
                evaluator = (TopicExpressionEvaluator)JNDIUtils.lookup(context, TOPIC_EXPRESSION_EVALUATOR_CONTEXT + "/" + pair.getName(), class$org$globus$wsrf$topicexpression$TopicExpressionEvaluator == null ? TopicExpressionEngineImpl.class$("org.globus.wsrf.topicexpression.TopicExpressionEvaluator") : class$org$globus$wsrf$topicexpression$TopicExpressionEvaluator);
                this.registerEvaluator(evaluator);
            }
        }
        catch (NamingException e) {
            logger.error(i18n.getMessage("topicEngineInitError"), e);
        }
        finally {
            if (list != null) {
                try {
                    list.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    public synchronized void registerEvaluator(TopicExpressionEvaluator evaluator) {
        logger.debug("Adding dialects for " + evaluator.getClass().getName());
        String[] dialects = evaluator.getDialects();
        for (int i = 0; i < dialects.length; ++i) {
            logger.debug("Adding dialect: " + dialects[i]);
            this.evaluators.put(dialects[i], evaluator);
        }
    }

    public synchronized TopicExpressionEvaluator getEvaluator(String dialect) {
        TopicExpressionEvaluator evaluator = (TopicExpressionEvaluator)this.evaluators.get(dialect);
        return evaluator;
    }

    public synchronized Collection resolveTopicExpression(TopicExpressionType topicExpression, TopicList topicList) throws UnsupportedTopicExpressionDialectException, TopicExpressionResolutionException, InvalidTopicExpressionException, TopicExpressionException {
        if (topicExpression == null) {
            throw new InvalidTopicExpressionException(i18n.getMessage("nullArgument", "topicExpression"));
        }
        if (topicExpression.getDialect() == null) {
            throw new UnsupportedTopicExpressionDialectException(i18n.getMessage("nullArgument", "topicExpression.dialect"));
        }
        String dialect = topicExpression.getDialect().toString();
        TopicExpressionEvaluator evaluator = this.getEvaluator(dialect);
        if (evaluator == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Dialect not supported:" + dialect);
                logger.debug("Registered dialects are:");
                Iterator keyIterator = this.evaluators.keySet().iterator();
                Object key = null;
                while (keyIterator.hasNext()) {
                    key = keyIterator.next();
                    logger.debug(key);
                }
                logger.debug("key.equals(dialect): " + key.equals(dialect.toString()));
                logger.debug("this.evaluators.containsKey(dialect): " + this.evaluators.containsKey(dialect.toString()));
                logger.debug("HashCode of key: " + String.valueOf(key.hashCode()));
                logger.debug("HashCode of dialect: " + String.valueOf(dialect.toString().hashCode()));
                logger.debug("Object stored for key: " + this.evaluators.get(key));
            }
            throw new UnsupportedTopicExpressionDialectException();
        }
        return evaluator.resolve(topicExpression, topicList);
    }

    public synchronized List getConcretePath(TopicExpressionType topicExpression) throws UnsupportedTopicExpressionDialectException, TopicExpressionResolutionException, InvalidTopicExpressionException, TopicExpressionException {
        if (topicExpression == null) {
            throw new InvalidTopicExpressionException(i18n.getMessage("nullArgument", "topicExpression"));
        }
        if (topicExpression.getDialect() == null) {
            throw new UnsupportedTopicExpressionDialectException(i18n.getMessage("nullArgument", "topicExpression.dialect"));
        }
        String dialect = topicExpression.getDialect().toString();
        TopicExpressionEvaluator evaluator = this.getEvaluator(dialect);
        if (evaluator == null) {
            throw new UnsupportedTopicExpressionDialectException();
        }
        return evaluator.getConcreteTopicPath(topicExpression);
    }

    public synchronized String[] getSupportedDialects() {
        return this.evaluators.keySet().toArray(new String[this.evaluators.size()]);
    }
}

